/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.worker;

import cn.feiliu.taskflow.common.metadata.tasks.ExecutingTask;
import cn.feiliu.taskflow.common.metadata.tasks.TaskExecResult;
import cn.feiliu.taskflow.sdk.config.WorkerPropertyManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Worker {
    public static final Logger logger = LoggerFactory.getLogger(Worker.class);

    public String getTaskDefName();

    public TaskExecResult execute(ExecutingTask var1) throws Throwable;

    default public void onErrorUpdate(ExecutingTask task) {
    }

    default public boolean paused() {
        return WorkerPropertyManager.paused(this.getTaskDefName());
    }

    default public String getIdentity() {
        String serverId;
        try {
            serverId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            serverId = System.getenv("HOSTNAME");
        }
        if (serverId == null) {
            serverId = System.getProperty("user.name");
        }
        logger.debug("Setting worker id to {}", (Object)serverId);
        return serverId;
    }

    default public int getPollingInterval() {
        return WorkerPropertyManager.getPollingInterval(this.getTaskDefName());
    }

    default public boolean leaseExtendEnabled() {
        return WorkerPropertyManager.leaseExtendEnabled(this.getTaskDefName());
    }

    default public int getBatchPollTimeoutInMS() {
        return WorkerPropertyManager.getBatchPollTimeoutInMS(this.getTaskDefName());
    }

    public static Worker create(final String taskType, final Function<ExecutingTask, TaskExecResult> executor) {
        return new Worker(){

            @Override
            public String getTaskDefName() {
                return taskType;
            }

            @Override
            public TaskExecResult execute(ExecutingTask task) throws Throwable {
                return (TaskExecResult)executor.apply(task);
            }

            @Override
            public boolean paused() {
                return Worker.super.paused();
            }
        };
    }
}

