/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.utils.JsValidator;
import cn.feiliu.taskflow.common.utils.TaskflowUtils;
import cn.feiliu.taskflow.common.utils.Validator;
import cn.feiliu.taskflow.expression.PathExpression;
import cn.feiliu.taskflow.sdk.workflow.def.ILoopTask;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DoWhile
extends Task<DoWhile>
implements ILoopTask<DoWhile> {
    private String loopCondition;
    public static final String LOOP_COUNT = "loopCount";
    private final List<Task<?>> loopTasks = new ArrayList();

    public DoWhile(String taskReferenceName, String expression) {
        super(taskReferenceName, TaskType.DO_WHILE);
        JsValidator.assertVariableName(taskReferenceName);
        if (!Validator.isExpression(expression)) {
            throw new IllegalArgumentException("expression should be a valid expression");
        }
        this.input(LOOP_COUNT, expression);
        this.loopCondition = this.getForLoopCondition();
    }

    public DoWhile(String taskReferenceName, PathExpression expression) {
        this(taskReferenceName, expression.getExpression());
    }

    public DoWhile(String taskReferenceName, int loopCount) {
        super(taskReferenceName, TaskType.DO_WHILE);
        this.loopCondition = this.getForLoopCondition(loopCount);
    }

    DoWhile(FlowTask workflowTask) {
        super(workflowTask);
        this.loopCondition = workflowTask.getLoopCondition();
        for (FlowTask task : workflowTask.getLoopOver()) {
            Task<?> loopTask = TaskRegistry.getTask(task);
            this.loopTasks.add(loopTask);
        }
    }

    @Override
    public DoWhile childTask(Task<?> task) {
        this.loopTasks.add(task);
        return this;
    }

    private String getForLoopCondition(int loopCount) {
        if (loopCount < 0) {
            throw new IllegalArgumentException("loopCount must be greater than or equal to zero");
        }
        JsValidator.assertVariableName(this.getTaskReferenceName());
        return "if ( $." + this.getTaskReferenceName() + "['iteration'] < " + loopCount + ") { true; } else { false; }";
    }

    private String getForLoopCondition() {
        JsValidator.assertVariableName(this.getTaskReferenceName());
        return TaskflowUtils.f("if ( $.%s['iteration'] < $.loopCount ) { true; } else { false; }", this.getTaskReferenceName());
    }

    public DoWhile setLoopCondition(String condition) {
        this.loopCondition = Objects.requireNonNull(condition);
        return this;
    }

    public String getLoopCondition() {
        return this.loopCondition;
    }

    public List<? extends Task> getLoopTasks() {
        return this.loopTasks;
    }

    @Override
    public void updateWorkflowTask(FlowTask workflowTask) {
        workflowTask.setLoopCondition(this.loopCondition);
        ArrayList<FlowTask> loopWorkflowTasks = new ArrayList<FlowTask>();
        for (Task<?> task : this.loopTasks) {
            loopWorkflowTasks.addAll(task.getWorkflowDefTasks());
        }
        workflowTask.setLoopOver(loopWorkflowTasks);
    }
}

