/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.expression.Expr;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Join;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.WorkTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public class DynamicFork
extends Task<DynamicFork> {
    public static final String FORK_TASK_PARAM = "forkedTasks";
    public static final String FORK_TASK_INPUT_PARAM = "forkedTasksInputs";
    private String forkTasksParameter;
    private String forkTasksInputsParameter;
    private Join join;
    private WorkTask forkPrepareTask;

    public DynamicFork(String taskReferenceName, String forkTasksParameter, String forkTasksInputsParameter) {
        super(taskReferenceName, TaskType.FORK_JOIN_DYNAMIC);
        this.join = new Join(taskReferenceName + "_join", new String[0]);
        this.forkTasksParameter = forkTasksParameter;
        this.forkTasksInputsParameter = forkTasksInputsParameter;
        super.input(FORK_TASK_PARAM, forkTasksParameter);
        super.input(FORK_TASK_INPUT_PARAM, forkTasksInputsParameter);
    }

    public DynamicFork(String taskReferenceName, WorkTask forkPrepareTask) {
        super(taskReferenceName, TaskType.FORK_JOIN_DYNAMIC);
        this.forkPrepareTask = forkPrepareTask;
        this.join = new Join(taskReferenceName + "_join", new String[0]);
        this.forkTasksParameter = Expr.task((String)forkPrepareTask.getTaskReferenceName()).output.get(FORK_TASK_PARAM).getExpression();
        this.forkTasksInputsParameter = Expr.task((String)forkPrepareTask.getTaskReferenceName()).output.get(FORK_TASK_INPUT_PARAM).getExpression();
        super.input(FORK_TASK_PARAM, this.forkTasksParameter);
        super.input(FORK_TASK_INPUT_PARAM, this.forkTasksInputsParameter);
    }

    DynamicFork(FlowTask workflowTask) {
        super(workflowTask);
        String nameOfParamForForkTask = workflowTask.getDynamicForkTasksParam();
        String nameOfParamForForkTaskInput = workflowTask.getDynamicForkTasksInputParamName();
        this.forkTasksParameter = (String)workflowTask.getInputParameters().get(nameOfParamForForkTask);
        this.forkTasksInputsParameter = (String)workflowTask.getInputParameters().get(nameOfParamForForkTaskInput);
    }

    public Join getJoin() {
        return this.join;
    }

    public String getForkTasksParameter() {
        return this.forkTasksParameter;
    }

    public String getForkTasksInputsParameter() {
        return this.forkTasksInputsParameter;
    }

    @Override
    public void updateWorkflowTask(FlowTask task) {
        task.setDynamicForkTasksParam(FORK_TASK_PARAM);
        task.setDynamicForkTasksInputParamName(FORK_TASK_INPUT_PARAM);
    }

    @Override
    protected List<FlowTask> getChildrenTasks() {
        ArrayList<FlowTask> tasks = new ArrayList<FlowTask>();
        tasks.addAll(this.join.getWorkflowDefTasks());
        return tasks;
    }

    @Override
    protected List<FlowTask> getParentTasks() {
        if (this.forkPrepareTask != null) {
            return List.of(this.forkPrepareTask.toWorkflowTask());
        }
        return List.of();
    }

    public void refreshInput(Function<Pair<String, String>, Object> function) {
        for (Map.Entry<String, Object> entry : this.forkPrepareTask.getInput().entrySet()) {
            Object newValue;
            if (!(entry.getValue() instanceof String) || (newValue = function.apply((Pair<String, String>)Pair.of((Object)entry.getKey(), (Object)((String)entry.getValue())))) == null) continue;
            entry.setValue(newValue);
        }
    }
}

