/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.utils.JsValidator;
import cn.feiliu.taskflow.common.utils.Validator;
import cn.feiliu.taskflow.expression.PathExpression;
import cn.feiliu.taskflow.sdk.workflow.def.ILoopTask;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.List;

public class For
extends Task<For>
implements ILoopTask<For> {
    public static final String ELEMENTS = "elements";
    private String loopCondition;
    private final List<Task<?>> loopTasks = new ArrayList();

    public For(String taskReferenceName, String eachExpression) {
        super(taskReferenceName, TaskType.FOR_EACH);
        JsValidator.assertVariableName(taskReferenceName);
        if (!Validator.isExpression(eachExpression)) {
            throw new IllegalArgumentException("expression should be a valid expression");
        }
        this.input(ELEMENTS, eachExpression);
        this.loopCondition = String.format("if($.%s['iteration'] < $.loopCount){ true; }else{ false; }", this.getTaskReferenceName());
    }

    public For(String taskReferenceName, PathExpression expression) {
        this(taskReferenceName, expression.getExpression());
    }

    For(FlowTask workflowTask) {
        super(workflowTask);
        this.loopCondition = workflowTask.getLoopCondition();
        for (FlowTask task : workflowTask.getLoopOver()) {
            Task<?> loopTask = TaskRegistry.getTask(task);
            this.loopTasks.add(loopTask);
        }
    }

    @Override
    public For childTask(Task<?> task) {
        this.loopTasks.add(task);
        return this;
    }

    @Override
    public void updateWorkflowTask(FlowTask workflowTask) {
        workflowTask.setLoopCondition(this.loopCondition);
        ArrayList<FlowTask> loopWorkflowTasks = new ArrayList<FlowTask>();
        for (Task<?> task : this.loopTasks) {
            loopWorkflowTasks.addAll(task.getWorkflowDefTasks());
        }
        workflowTask.setLoopOver(loopWorkflowTasks);
    }
}

