/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.utils.JsValidator;
import cn.feiliu.taskflow.common.utils.Validator;
import cn.feiliu.taskflow.expression.PathExpression;
import cn.feiliu.taskflow.sdk.workflow.def.ILoopTask;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.List;

public class ForkFor
extends Task<ForkFor>
implements ILoopTask<ForkFor> {
    public static final String ELEMENTS = "elements";
    private final List<Task<?>> loopTasks = new ArrayList();

    public ForkFor(String taskReferenceName, String eachExpression) {
        super(taskReferenceName, TaskType.FORK_FOR_EACH);
        JsValidator.assertVariableName(taskReferenceName);
        if (!Validator.isExpression(eachExpression)) {
            throw new IllegalArgumentException("expression should be a valid expression");
        }
        this.input(ELEMENTS, eachExpression);
    }

    public ForkFor(String taskReferenceName, PathExpression eachExpression) {
        this(taskReferenceName, eachExpression.getExpression());
    }

    ForkFor(FlowTask workflowTask) {
        super(workflowTask);
        for (FlowTask task : workflowTask.getLoopOver()) {
            Task<?> loopTask = TaskRegistry.getTask(task);
            this.loopTasks.add(loopTask);
        }
    }

    @Override
    public ForkFor childTask(Task<?> task) {
        this.loopTasks.add(task);
        return this;
    }

    @Override
    public void updateWorkflowTask(FlowTask workflowTask) {
        ArrayList<FlowTask> loopWorkflowTasks = new ArrayList<FlowTask>();
        for (Task<?> task : this.loopTasks) {
            loopWorkflowTasks.addAll(task.getWorkflowDefTasks());
        }
        workflowTask.setLoopOver(loopWorkflowTasks);
    }
}

