/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Join;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ForkJoin
extends Task<ForkJoin> {
    private Join join;
    private Task[][] forkedTasks;

    public ForkJoin(String taskReferenceName, Task<?>[] ... forkedTasks) {
        super(taskReferenceName, TaskType.FORK_JOIN);
        this.forkedTasks = forkedTasks;
    }

    ForkJoin(FlowTask workflowTask) {
        super(workflowTask);
        int size = workflowTask.getForkTasks().size();
        this.forkedTasks = new Task[size][];
        int i = 0;
        for (List<FlowTask> forkTasks : workflowTask.getForkTasks()) {
            Task[] tasks = new Task[forkTasks.size()];
            for (int j = 0; j < forkTasks.size(); ++j) {
                Task<?> task;
                FlowTask forkWorkflowTask = forkTasks.get(j);
                tasks[j] = task = TaskRegistry.getTask(forkWorkflowTask);
            }
            this.forkedTasks[i++] = tasks;
        }
    }

    public ForkJoin joinOn(String ... joinOn) {
        this.join = new Join(this.getTaskReferenceName() + "_join", joinOn);
        return this;
    }

    @Override
    protected List<FlowTask> getChildrenTasks() {
        FlowTask fork = this.toWorkflowTask();
        FlowTask joinWorkflowTask = null;
        if (this.join != null) {
            List<FlowTask> joinTasks = this.join.getWorkflowDefTasks();
            joinWorkflowTask = joinTasks.get(0);
        } else {
            joinWorkflowTask = new FlowTask();
            joinWorkflowTask.setType(TaskType.JOIN);
            joinWorkflowTask.setTaskReferenceName(this.getTaskReferenceName() + "_join");
            joinWorkflowTask.setName(joinWorkflowTask.getTaskReferenceName());
            joinWorkflowTask.setJoinOn(fork.getJoinOn());
        }
        return Arrays.asList(joinWorkflowTask);
    }

    @Override
    public void updateWorkflowTask(FlowTask fork) {
        ArrayList<String> joinOnTaskRefNames = new ArrayList<String>();
        ArrayList<List<FlowTask>> forkTasks = new ArrayList<List<FlowTask>>();
        for (Task[] forkedTaskList : this.forkedTasks) {
            ArrayList<FlowTask> forkedWorkflowTasks = new ArrayList<FlowTask>();
            for (Task baseWorkflowTask : forkedTaskList) {
                forkedWorkflowTasks.addAll(baseWorkflowTask.getWorkflowDefTasks());
            }
            forkTasks.add(forkedWorkflowTasks);
            joinOnTaskRefNames.add(((FlowTask)forkedWorkflowTasks.get(forkedWorkflowTasks.size() - 1)).getTaskReferenceName());
        }
        if (this.join != null) {
            fork.setJoinOn(List.of(this.join.getJoinOn()));
        } else {
            fork.setJoinOn(joinOnTaskRefNames);
        }
        fork.setForkTasks(forkTasks);
    }

    public Task[][] getForkedTasks() {
        return this.forkedTasks;
    }
}

