/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.serialization.SerializerFactory;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http
extends Task<Http> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http.class);
    private static final String INPUT_PARAM = "http_request";
    private Input httpRequest;

    public Http(String taskReferenceName) {
        super(taskReferenceName, TaskType.HTTP);
        this.httpRequest = new Input();
        this.httpRequest.method = Input.HttpMethod.GET;
        super.input(INPUT_PARAM, (Object)this.httpRequest);
    }

    Http(FlowTask workflowTask) {
        super(workflowTask);
        Object inputRequest = workflowTask.getInputParameters().get(INPUT_PARAM);
        if (inputRequest != null) {
            this.httpRequest = (Input)SerializerFactory.getSerializer().convert(inputRequest, (Type)((Object)Input.class));
        }
    }

    public Http input(Input httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public Http url(String url) {
        this.httpRequest.setUri(url);
        return this;
    }

    public Http method(Input.HttpMethod method) {
        this.httpRequest.setMethod(method);
        return this;
    }

    public Http headers(Map<String, Object> headers) {
        this.httpRequest.setHeaders(headers);
        return this;
    }

    public Http body(Object body) {
        this.httpRequest.setBody(body);
        return this;
    }

    public Http readTimeout(int readTimeout) {
        this.httpRequest.setReadTimeOut(readTimeout);
        return this;
    }

    public Input getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    protected void updateWorkflowTask(FlowTask workflowTask) {
        workflowTask.getInputParameters().put(INPUT_PARAM, this.httpRequest);
    }

    public static class Input {
        private HttpMethod method;
        private String vipAddress;
        private String appName;
        private Map<String, Object> headers = new HashMap<String, Object>();
        private String uri;
        private Object body;
        private String accept = "application/json";
        private String contentType = "application/json";
        private Integer connectionTimeOut;
        private Integer readTimeOut;

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        public Object getBody() {
            return this.body;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getVipAddress() {
            return this.vipAddress;
        }

        public void setVipAddress(String vipAddress) {
            this.vipAddress = vipAddress;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public Integer getConnectionTimeOut() {
            return this.connectionTimeOut;
        }

        public Integer getReadTimeOut() {
            return this.readTimeOut;
        }

        public void setConnectionTimeOut(Integer connectionTimeOut) {
            this.connectionTimeOut = connectionTimeOut;
        }

        public void setReadTimeOut(Integer readTimeOut) {
            this.readTimeOut = readTimeOut;
        }

        public String toString() {
            return "Input{method=" + this.method + ", vipAddress='" + this.vipAddress + "', appName='" + this.appName + "', headers=" + this.headers + ", uri='" + this.uri + "', body=" + this.body + ", accept='" + this.accept + "', contentType='" + this.contentType + "', connectionTimeOut=" + this.connectionTimeOut + ", readTimeOut=" + this.readTimeOut + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input input = (Input)o;
            return this.method == input.method && Objects.equals(this.vipAddress, input.vipAddress) && Objects.equals(this.appName, input.appName) && Objects.equals(this.headers, input.headers) && Objects.equals(this.uri, input.uri) && Objects.equals(this.body, input.body) && Objects.equals(this.accept, input.accept) && Objects.equals(this.contentType, input.contentType) && Objects.equals(this.connectionTimeOut, input.connectionTimeOut) && Objects.equals(this.readTimeOut, input.readTimeOut);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.method, this.vipAddress, this.appName, this.headers, this.uri, this.body, this.accept, this.contentType, this.connectionTimeOut, this.readTimeOut});
        }

        public static enum HttpMethod {
            PUT,
            POST,
            GET,
            DELETE,
            OPTIONS,
            HEAD;

        }
    }
}

