/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.metadata.workflow.SubFlowParams;
import cn.feiliu.taskflow.common.metadata.workflow.WorkflowDefinition;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;

public class SubWorkflow
extends Task<SubWorkflow> {
    private String workflowName;
    private Integer workflowVersion;
    private WorkflowDefinition workflowDefinition = null;

    public SubWorkflow(String taskReferenceName, String workflowName, Integer workflowVersion) {
        super(taskReferenceName, TaskType.SUB_WORKFLOW);
        this.workflowName = workflowName;
        this.workflowVersion = workflowVersion;
    }

    SubWorkflow(FlowTask workflowTask) {
        super(workflowTask);
        SubFlowParams subworkflowParam = workflowTask.getSubWorkflowParam();
        this.workflowName = subworkflowParam.getName();
        this.workflowVersion = subworkflowParam.getVersion();
        this.workflowDefinition = subworkflowParam.getWorkflowDefinition();
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public int getWorkflowVersion() {
        return this.workflowVersion;
    }

    @Override
    protected void updateWorkflowTask(FlowTask workflowTask) {
        SubFlowParams subWorkflowParam = new SubFlowParams();
        subWorkflowParam.setName(this.workflowName);
        subWorkflowParam.setVersion(this.workflowVersion);
        if (this.workflowDefinition != null) {
            subWorkflowParam.setWorkflowDefinition(this.workflowDefinition);
        }
        workflowTask.setSubWorkflowParam(subWorkflowParam);
    }
}

