/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.expression.PathExpression;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.TaskRegistry;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.WorkTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Switch
extends Task<Switch> {
    public static final String VALUE_PARAM_NAME = "value-param";
    public static final String JAVASCRIPT_NAME = "javascript";
    private String caseExpression;
    private boolean useJavascript;
    private List<Task<?>> defaultTasks = new ArrayList();
    private Map<String, List<Task<?>>> branches = new HashMap();

    public Switch(String taskReferenceName, String caseExpression, boolean useJavascript) {
        super(taskReferenceName, TaskType.SWITCH);
        this.caseExpression = caseExpression;
        this.useJavascript = useJavascript;
    }

    public Switch(String taskReferenceName, PathExpression expression, boolean useJavascript) {
        this(taskReferenceName, expression.getExpression(), useJavascript);
    }

    public Switch(String taskReferenceName, String caseExpression) {
        super(taskReferenceName, TaskType.SWITCH);
        this.caseExpression = caseExpression;
        this.useJavascript = false;
    }

    public Switch(String taskReferenceName, PathExpression expression) {
        this(taskReferenceName, expression.getExpression());
    }

    Switch(FlowTask workflowTask) {
        super(workflowTask);
        Map<String, List<FlowTask>> decisions = workflowTask.getDecisionCases();
        decisions.entrySet().stream().forEach(branch -> {
            String branchName = (String)branch.getKey();
            List branchWorkflowTasks = (List)branch.getValue();
            ArrayList branchTasks = new ArrayList();
            for (FlowTask branchWorkflowTask : branchWorkflowTasks) {
                branchTasks.add(TaskRegistry.getTask(branchWorkflowTask));
            }
            this.branches.put(branchName, branchTasks);
        });
        List<FlowTask> defaultCases = workflowTask.getDefaultCase();
        for (FlowTask defaultCase : defaultCases) {
            this.defaultTasks.add(TaskRegistry.getTask(defaultCase));
        }
    }

    public Switch defaultCase(Task<?> ... tasks) {
        this.defaultTasks = Arrays.asList(tasks);
        return this;
    }

    public Switch defaultCase(List<Task<?>> defaultTasks) {
        this.defaultTasks = defaultTasks;
        return this;
    }

    public Switch decisionCases(Map<String, List<Task<?>>> branches) {
        this.branches = branches;
        return this;
    }

    public Switch defaultCase(String ... workerTasks) {
        for (String workerTask : workerTasks) {
            this.defaultTasks.add(new WorkTask(workerTask, workerTask));
        }
        return this;
    }

    public Switch switchCase(String caseValue, Task ... tasks) {
        this.branches.put(caseValue, Arrays.asList(tasks));
        return this;
    }

    public Switch switchCase(String caseValue, String ... workerTasks) {
        ArrayList<WorkTask> tasks = new ArrayList<WorkTask>(workerTasks.length);
        boolean i = false;
        for (String workerTask : workerTasks) {
            tasks.add(new WorkTask(workerTask, workerTask));
        }
        this.branches.put(caseValue, tasks);
        return this;
    }

    public List<Task<?>> getDefaultTasks() {
        return this.defaultTasks;
    }

    public Map<String, List<Task<?>>> getBranches() {
        return this.branches;
    }

    @Override
    public void updateWorkflowTask(FlowTask workflowTask) {
        if (this.useJavascript) {
            workflowTask.setEvaluatorType(JAVASCRIPT_NAME);
            workflowTask.setExpression(this.caseExpression);
        } else {
            workflowTask.setEvaluatorType(VALUE_PARAM_NAME);
            workflowTask.getInputParameters().put("switchCaseValue", this.caseExpression);
            workflowTask.setExpression("switchCaseValue");
        }
        HashMap<String, List<FlowTask>> decisionCases = new HashMap<String, List<FlowTask>>();
        this.branches.entrySet().forEach(entry -> {
            String decisionCase = (String)entry.getKey();
            List decisionTasks = (List)entry.getValue();
            ArrayList<FlowTask> decionTaskDefs = new ArrayList<FlowTask>(decisionTasks.size());
            for (Task decisionTask : decisionTasks) {
                decionTaskDefs.addAll(decisionTask.getWorkflowDefTasks());
            }
            decisionCases.put(decisionCase, decionTaskDefs);
        });
        workflowTask.setDecisionCases(decisionCases);
        ArrayList<FlowTask> defaultCaseTaskDefs = new ArrayList<FlowTask>(this.defaultTasks.size());
        for (Task<?> defaultTask : this.defaultTasks) {
            defaultCaseTaskDefs.addAll(defaultTask.getWorkflowDefTasks());
        }
        workflowTask.setDefaultCase(defaultCaseTaskDefs);
    }
}

