/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.def.tasks;

import cn.feiliu.taskflow.common.metadata.tasks.TaskType;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.utils.Validator;
import cn.feiliu.taskflow.expression.PathExpression;
import cn.feiliu.taskflow.sdk.workflow.utils.MapBuilder;
import cn.feiliu.taskflow.serialization.SerializerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;

public abstract class Task<T> {
    @NotEmpty(message="Task name cannot be empty or null")
    private @NotEmpty(message="Task name cannot be empty or null") String name;
    @NotEmpty(message="Task taskReferenceName name cannot be empty or null")
    private @NotEmpty(message="Task taskReferenceName name cannot be empty or null") String taskReferenceName;
    private String description;
    private boolean optional;
    private int startDelay;
    private TaskType type;
    private Map<String, Object> input = new HashMap<String, Object>();

    public Task(String taskReferenceName, TaskType type) {
        Validator.assertTaskRefName(taskReferenceName);
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.name = taskReferenceName;
        this.taskReferenceName = taskReferenceName;
        this.type = type;
    }

    Task(FlowTask workflowTask) {
        this(workflowTask.getTaskReferenceName(), workflowTask.getType());
        this.input = workflowTask.getInputParameters();
        this.description = workflowTask.getDescription();
        this.name = workflowTask.getName();
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T description(String description) {
        this.description = description;
        return (T)this;
    }

    public T input(String key, boolean value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, Object value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, char value) {
        this.input.put(key, Character.valueOf(value));
        return (T)this;
    }

    public T input(String key, PathExpression pathExpression) {
        this.input.put(key, pathExpression.getExpression());
        return (T)this;
    }

    public T input(String key, String value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, Number value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(String key, Map<String, Object> value) {
        this.input.put(key, value);
        return (T)this;
    }

    public T input(Map<String, Object> map) {
        this.input.putAll(map);
        return (T)this;
    }

    public T input(MapBuilder builder) {
        this.input.putAll(builder.build());
        return (T)this;
    }

    public T input(Object ... keyValues) {
        if (keyValues.length == 1) {
            Object kv = keyValues[0];
            this.input.putAll(SerializerFactory.getSerializer().convertMap(kv));
            return (T)this;
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("Not all keys have value specified");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = keyValues[i].toString();
            Object value = keyValues[i + 1];
            this.input.put(key, value);
        }
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public TaskType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public final List<FlowTask> getWorkflowDefTasks() {
        ArrayList<FlowTask> workflowTasks = new ArrayList<FlowTask>();
        workflowTasks.addAll(this.getParentTasks());
        workflowTasks.add(this.toWorkflowTask());
        workflowTasks.addAll(this.getChildrenTasks());
        return workflowTasks;
    }

    protected final FlowTask toWorkflowTask() {
        FlowTask workflowTask = new FlowTask();
        workflowTask.setName(this.name);
        workflowTask.setTaskReferenceName(this.taskReferenceName);
        workflowTask.setType(this.type);
        workflowTask.setDescription(this.description);
        workflowTask.setInputParameters(this.input);
        this.updateWorkflowTask(workflowTask);
        return workflowTask;
    }

    protected void updateWorkflowTask(FlowTask workflowTask) {
    }

    protected List<FlowTask> getChildrenTasks() {
        return List.of();
    }

    protected List<FlowTask> getParentTasks() {
        return List.of();
    }
}

