/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.executor.extension;

import cn.feiliu.taskflow.common.utils.Validator;
import cn.feiliu.taskflow.sdk.workflow.executor.extension.TaskHandler;
import cn.feiliu.taskflow.sdk.workflow.task.WorkerTask;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskHandlerManager {
    private final Map<String, TaskHandler> taskMap = new ConcurrentHashMap<String, TaskHandler>();

    public void registerTask(WorkerTask worker, Object bean, Method method) {
        if (worker == null || bean == null || method == null) {
            throw new IllegalArgumentException("worker, bean, method must not be null");
        }
        Validator.assertTaskName(worker.value());
        if (this.taskMap.containsKey(worker.value())) {
            throw new IllegalArgumentException("taskName:`" + worker.value() + "` already exists");
        }
        this.taskMap.put(worker.value(), new TaskHandler(worker, bean, method));
    }

    public Optional<TaskHandler> getTaskHandler(String taskName) {
        return Optional.ofNullable(this.taskMap.get(taskName));
    }

    public Map<String, TaskHandler> getTasks() {
        return Collections.unmodifiableMap(this.taskMap);
    }

    public Set<String> getTaskNames() {
        return Collections.unmodifiableSet(this.taskMap.keySet());
    }
}

