/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.executor.task;

import cn.feiliu.taskflow.common.metadata.tasks.ExecutingTask;
import cn.feiliu.taskflow.common.metadata.tasks.TaskExecResult;
import cn.feiliu.taskflow.common.metadata.workflow.FlowTask;
import cn.feiliu.taskflow.common.utils.TaskflowUtils;
import cn.feiliu.taskflow.open.exceptions.TaskParameterException;
import cn.feiliu.taskflow.sdk.worker.Worker;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.DynamicForkInput;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.Task;
import cn.feiliu.taskflow.sdk.workflow.executor.task.NonRetryableException;
import cn.feiliu.taskflow.sdk.workflow.executor.task.TaskContext;
import cn.feiliu.taskflow.sdk.workflow.task.InputParam;
import cn.feiliu.taskflow.sdk.workflow.task.OutputParam;
import cn.feiliu.taskflow.serialization.SerializerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedWorker
implements Worker {
    private static Logger log = LoggerFactory.getLogger(AnnotatedWorker.class);
    private String name;
    private Method workerMethod;
    private Object obj;
    private int pollingInterval = 100;
    private Set<TaskExecResult.Status> failedStatuses = Set.of(TaskExecResult.Status.FAILED, TaskExecResult.Status.FAILED_WITH_TERMINAL_ERROR);

    public AnnotatedWorker(String name, Method workerMethod, Object obj) {
        this.name = name;
        this.workerMethod = workerMethod;
        this.obj = obj;
    }

    @Override
    public String getTaskDefName() {
        return this.name;
    }

    @Override
    public TaskExecResult execute(ExecutingTask task) throws Throwable {
        TaskExecResult result = null;
        try {
            TaskContext context = TaskContext.set(task);
            Object[] parameters = this.getInvocationParameters(task);
            Object invocationResult = this.workerMethod.invoke(this.obj, parameters);
            result = this.setValue(invocationResult, context.getTaskResult());
            if (!this.failedStatuses.contains((Object)result.getStatus()) && result.getCallbackAfterSeconds() > 0L) {
                result.setStatus(TaskExecResult.Status.IN_PROGRESS);
            }
        }
        catch (TaskParameterException e) {
            if (result == null) {
                result = new TaskExecResult(task);
            }
            result.setStatus(TaskExecResult.Status.FAILED);
            result.setReasonForIncompletion(e.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (result == null) {
                result = new TaskExecResult(task);
            }
            Throwable e = invocationTargetException.getCause();
            log.error("invocation error", e);
            if (e instanceof NonRetryableException) {
                result.setStatus(TaskExecResult.Status.FAILED_WITH_TERMINAL_ERROR);
            } else {
                result.setStatus(TaskExecResult.Status.FAILED);
            }
            result.setReasonForIncompletion(e.getMessage());
            result.log(TaskflowUtils.dumpStackTrace(e));
        }
        catch (Throwable e) {
            throw e;
        }
        return result;
    }

    private Object[] getInvocationParameters(ExecutingTask task) {
        Optional<InputParam> optional;
        Class<?>[] parameterTypes = this.workerMethod.getParameterTypes();
        Parameter[] parameters = this.workerMethod.getParameters();
        if (parameterTypes.length == 1 && parameterTypes[0].equals(ExecutingTask.class)) {
            return new Object[]{task};
        }
        if (parameterTypes.length == 1 && parameterTypes[0].equals(Map.class) && (optional = AnnotatedWorker.findInputParamAnnotation(this.workerMethod.getParameterAnnotations()[0])).isEmpty()) {
            return new Object[]{task.getInputData()};
        }
        return this.getParameters(task, parameterTypes, parameters);
    }

    private Object[] getParameters(ExecutingTask task, Class<?>[] parameterTypes, Parameter[] parameters) {
        Annotation[][] parameterAnnotations = this.workerMethod.getParameterAnnotations();
        Object[] values = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] paramAnnotation = parameterAnnotations[i];
            if (paramAnnotation != null && paramAnnotation.length > 0) {
                Type type = parameters[i].getParameterizedType();
                Class<?> parameterType = parameterTypes[i];
                values[i] = this.getInputValue(task, parameterType, type, paramAnnotation);
                continue;
            }
            values[i] = SerializerFactory.getSerializer().convert(task.getInputData(), parameterTypes[i]);
        }
        return values;
    }

    private Object getInputValue(ExecutingTask task, Class<?> parameterType, Type type, Annotation[] paramAnnotation) {
        Optional<InputParam> optional = AnnotatedWorker.findInputParamAnnotation(paramAnnotation);
        if (optional.isEmpty()) {
            return SerializerFactory.getSerializer().convert(task.getInputData(), parameterType);
        }
        InputParam inputParam = optional.get();
        Object value = task.getInputData().get(inputParam.value());
        if (value == null) {
            if (inputParam.required()) {
                throw new TaskParameterException(String.format("The required %s('%s') parameter is missing", this.name, inputParam.value()));
            }
            return null;
        }
        if (List.class.isAssignableFrom(parameterType)) {
            List<?> list = this.safeConvertList(inputParam, value);
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class typeOfParameter = (Class)parameterizedType.getActualTypeArguments()[0];
                ArrayList<Object> parameterizedList = new ArrayList<Object>();
                for (Object item : list) {
                    parameterizedList.add(this.safeConvert(inputParam, item, typeOfParameter));
                }
                return parameterizedList;
            }
            return list;
        }
        return this.safeConvert(inputParam, value, parameterType);
    }

    private List<?> safeConvertList(InputParam ip, Object value) {
        try {
            return SerializerFactory.getSerializer().convertList(value);
        }
        catch (Throwable t) {
            String msg = String.format("The required %s('%s') parameter is missing", this.name, ip.value());
            throw new TaskParameterException(msg, t);
        }
    }

    private Object safeConvert(InputParam ip, Object value, Class<?> type) {
        try {
            return SerializerFactory.getSerializer().convert(value, type);
        }
        catch (Throwable e) {
            String msg = String.format("The required %s('%s') parameter is missing", this.name, ip.value());
            throw new TaskParameterException(msg, e);
        }
    }

    private static Optional<InputParam> findInputParamAnnotation(Annotation[] paramAnnotation) {
        for (Annotation annotation : paramAnnotation) {
            if (annotation.annotationType() != InputParam.class) continue;
            return Optional.of((InputParam)annotation);
        }
        return Optional.empty();
    }

    private TaskExecResult setValue(Object invocationResult, TaskExecResult result) {
        if (invocationResult == null) {
            result.setStatus(TaskExecResult.Status.COMPLETED);
            return result;
        }
        OutputParam opAnnotation = this.workerMethod.getAnnotatedReturnType().getAnnotation(OutputParam.class);
        if (opAnnotation == null) {
            opAnnotation = this.workerMethod.getAnnotation(OutputParam.class);
        }
        if (opAnnotation != null) {
            String name = opAnnotation.value();
            result.getOutputData().put(name, invocationResult);
            result.setStatus(TaskExecResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof TaskExecResult) {
            return (TaskExecResult)invocationResult;
        }
        if (invocationResult instanceof Map) {
            Map resultAsMap = (Map)invocationResult;
            result.getOutputData().putAll(resultAsMap);
            result.setStatus(TaskExecResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof String || invocationResult instanceof Number || invocationResult instanceof Boolean) {
            result.getOutputData().put("result", invocationResult);
            result.setStatus(TaskExecResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof List) {
            List<Object> resultAsList = SerializerFactory.getSerializer().convertList(invocationResult);
            result.getOutputData().put("result", resultAsList);
            result.setStatus(TaskExecResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof DynamicForkInput) {
            DynamicForkInput forkInput = (DynamicForkInput)invocationResult;
            List<Task<?>> tasks = forkInput.getTasks();
            ArrayList<FlowTask> workflowTasks = new ArrayList<FlowTask>();
            for (Task<?> sdkTask : tasks) {
                workflowTasks.addAll(sdkTask.getWorkflowDefTasks());
            }
            result.getOutputData().put("forkedTasks", workflowTasks);
            result.getOutputData().put("forkedTasksInputs", forkInput.getInputs());
            result.setStatus(TaskExecResult.Status.COMPLETED);
            return result;
        }
        Map<String, Object> resultAsMap = SerializerFactory.getSerializer().convertMap(invocationResult);
        result.getOutputData().putAll(resultAsMap);
        result.setStatus(TaskExecResult.Status.COMPLETED);
        return result;
    }

    public void setPollingInterval(int pollingInterval) {
        log.info("Setting the polling interval for " + this.getTaskDefName() + ", to " + pollingInterval);
        this.pollingInterval = pollingInterval;
    }

    @Override
    public int getPollingInterval() {
        return this.pollingInterval;
    }
}

