/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.executor.task;

import cn.feiliu.taskflow.common.metadata.tasks.ExecutingTask;
import cn.feiliu.taskflow.common.metadata.tasks.TaskExecResult;
import cn.feiliu.taskflow.sdk.worker.Worker;
import cn.feiliu.taskflow.sdk.workflow.def.tasks.DynamicForkInput;
import cn.feiliu.taskflow.sdk.workflow.task.InputParam;
import cn.feiliu.taskflow.serialization.SerializerFactory;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;

public class DynamicForkWorker
implements Worker {
    private final int pollingInterval;
    private final Function<Object, DynamicForkInput> workerMethod;
    private final String name;

    public DynamicForkWorker(String name, Function<Object, DynamicForkInput> workerMethod, int pollingInterval) {
        this.name = name;
        this.workerMethod = workerMethod;
        this.pollingInterval = pollingInterval;
    }

    @Override
    public String getTaskDefName() {
        return this.name;
    }

    @Override
    public TaskExecResult execute(ExecutingTask task) throws Throwable {
        TaskExecResult result = new TaskExecResult(task);
        Object parameter = this.getInvocationParameters(this.workerMethod, task);
        DynamicForkInput output = this.workerMethod.apply(parameter);
        result.getOutputData().put("forkedTasks", output.getTasks());
        result.getOutputData().put("forkedTasksInputs", output.getInputs());
        result.setStatus(TaskExecResult.Status.COMPLETED);
        return result;
    }

    @Override
    public int getPollingInterval() {
        return this.pollingInterval;
    }

    private Object getInvocationParameters(Function<?, DynamicForkInput> function, ExecutingTask task) {
        InputParam annotation = null;
        Class<?> parameterType = null;
        for (Method method : function.getClass().getDeclaredMethods()) {
            if (!method.getReturnType().equals(DynamicForkInput.class)) continue;
            annotation = method.getParameters()[0].getAnnotation(InputParam.class);
            parameterType = method.getParameters()[0].getType();
        }
        if (parameterType.equals(ExecutingTask.class)) {
            return task;
        }
        if (parameterType.equals(Map.class)) {
            return task.getInputData();
        }
        if (annotation != null) {
            String name = annotation.value();
            Object value = task.getInputData().get(name);
            return SerializerFactory.getSerializer().convert(value, parameterType);
        }
        return SerializerFactory.getSerializer().convert(task.getInputData(), parameterType);
    }
}

