/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.sdk.workflow.executor.task;

import cn.feiliu.taskflow.common.metadata.tasks.ExecutingTask;
import cn.feiliu.taskflow.common.metadata.tasks.TaskExecResult;

public class TaskContext {
    public static final ThreadLocal<TaskContext> TASK_CONTEXT_INHERITABLE_THREAD_LOCAL = InheritableThreadLocal.withInitial(() -> null);
    private final ExecutingTask task;
    private final TaskExecResult taskResult;

    public TaskContext(ExecutingTask task, TaskExecResult taskResult) {
        this.task = task;
        this.taskResult = taskResult;
    }

    public static TaskContext get() {
        return TASK_CONTEXT_INHERITABLE_THREAD_LOCAL.get();
    }

    public static TaskContext set(ExecutingTask task) {
        TaskExecResult result = new TaskExecResult(task);
        TaskContext context = new TaskContext(task, result);
        TASK_CONTEXT_INHERITABLE_THREAD_LOCAL.set(context);
        return context;
    }

    public String getWorkflowInstanceId() {
        return this.task.getWorkflowInstanceId();
    }

    public String getTaskId() {
        return this.task.getTaskId();
    }

    public int getRetryCount() {
        return this.task.getRetryCount();
    }

    public int getPollCount() {
        return this.task.getPollCount();
    }

    public long getCallbackAfterSeconds() {
        return this.task.getCallbackAfterSeconds();
    }

    public void addLog(String log) {
        this.taskResult.log(log);
    }

    public ExecutingTask getTask() {
        return this.task;
    }

    public TaskExecResult getTaskResult() {
        return this.taskResult;
    }

    public void setCallbackAfter(int seconds) {
        this.taskResult.setCallbackAfterSeconds(seconds);
    }
}

