/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.serialization;

import cn.feiliu.taskflow.serialization.JsonProtoModule;
import cn.feiliu.taskflow.serialization.Serializer;
import cn.feiliu.taskflow.serialization.jackson.DateDeserializer;
import cn.feiliu.taskflow.serialization.jackson.DateSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.util.Types;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);
    static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> Map<String, T> convertMap(Object val, final Type valueType) {
        try {
            return (Map)objectMapper.convertValue(val, new TypeReference<Map<String, T>>(){

                public Type getType() {
                    return Types.mapOf(String.class, (Type)valueType);
                }
            });
        }
        catch (Exception e) {
            throw new ClassCastException("cannot map to Value type: " + val);
        }
    }

    @Override
    public Map<String, Object> convertMap(Object val) {
        return this.convertMap(val, (Type)((Object)Object.class));
    }

    @Override
    public <T> List<T> convertList(Object val, final Type elementType) {
        try {
            return (List)objectMapper.convertValue(val, new TypeReference<List<T>>(){

                public Type getType() {
                    return Types.listOf((Type)elementType);
                }
            });
        }
        catch (Exception e) {
            throw new ClassCastException("cannot list to Value type: " + val);
        }
    }

    @Override
    public <T> T convert(Object val, final Type targetType) {
        try {
            return (T)objectMapper.convertValue(val, new TypeReference<T>(){

                public Type getType() {
                    return targetType;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("Error while trying from: '%s' convert  to '%s' error:'%s'", val, targetType.getTypeName(), e.getMessage());
            log.error(msg, (Throwable)e);
            throw new ClassCastException(msg);
        }
    }

    @Override
    public String writeAsString(Object val) {
        try {
            return objectMapper.writeValueAsString(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> readList(InputStream resource, final Type elementType) {
        try {
            return (List)objectMapper.readValue(resource, new TypeReference<List<T>>(){

                public Type getType() {
                    return Types.listOf((Type)elementType);
                }
            });
        }
        catch (Exception e) {
            throw new ClassCastException("cannot list type:'" + elementType.getTypeName() + "'");
        }
    }

    @Override
    public <T> T read(InputStream resource, Class<T> targetType) {
        try {
            return (T)objectMapper.readValue(resource, targetType);
        }
        catch (Exception e) {
            throw new ClassCastException("Error reading data and converting type:'" + targetType.getName() + "'");
        }
    }

    @Override
    public Map<String, Object> readMap(InputStream resourceAsStream) {
        try {
            return (Map)objectMapper.readValue(resourceAsStream, Map.class);
        }
        catch (Exception e) {
            throw new ClassCastException("Error reading data and converting Map");
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.registerModule((Module)new JsonProtoModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        objectMapper.registerModule((Module)module);
    }
}

