/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateDeserializer
extends StdDeserializer<Date> {
    private static final long serialVersionUID = 1L;

    public DateDeserializer() {
        this(null);
    }

    protected DateDeserializer(Class<?> vc) {
        super(vc);
    }

    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String value = p.getText();
        if (value != null) {
            if (value.matches("\\d+")) {
                return new Date(Long.parseLong(value));
            }
            try {
                return new Date((long)Double.parseDouble(value));
            }
            catch (Exception e) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    return sdf.parse(p.getText());
                }
                catch (ParseException ex) {
                    throw new RuntimeException("Invalid date format", ex);
                }
            }
        }
        return null;
    }
}

