/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.dialect.AbstractSQLPagingDialect;
import java.sql.Connection;
import java.util.Map;

public class MySQLPagingDialect
extends AbstractSQLPagingDialect {
    private static final String PAGE_WRAP_START = "SELECT * FROM (";
    private static final String PAGE_WRAP_END = ") SQL_PAGING";
    private static final String LIMIT = " LIMIT %d,%d";
    private static final MySQLPagingDialect INSTANCE = new MySQLPagingDialect();

    public static final MySQLPagingDialect getInstance() {
        return INSTANCE;
    }

    protected MySQLPagingDialect() {
    }

    @Override
    public String pageSql(Connection con, String namedSql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) {
        int selectIndex = sqlMetaData.getSelectIndex();
        if (selectIndex > 0) {
            if (sqlMetaData.getLimitIndex() >= 0) {
                return StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), PAGE_WRAP_START, namedSql.substring(selectIndex), PAGE_WRAP_END, MySQLPagingDialect.generateLimit(pageSize, currentPage)});
            }
            return namedSql.concat(MySQLPagingDialect.generateLimit(pageSize, currentPage));
        }
        return StringUtils.concat((String[])new String[]{PAGE_WRAP_START, namedSql, PAGE_WRAP_END, MySQLPagingDialect.generateLimit(pageSize, currentPage)});
    }

    private static String generateLimit(int pageSize, long currentPage) {
        return String.format(LIMIT, (currentPage - 1L) * (long)pageSize, pageSize);
    }
}

