/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.dialect.AbstractSQLPagingDialect;
import cn.tenmg.sql.paging.utils.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class SQLServerPagingDialect
extends AbstractSQLPagingDialect {
    private static final String CONST_RN = " 1 RN__,";
    private static final String PAGE_WRAP_START = "SELECT %s FROM (";
    private static final String SUBQUERY_START = "SELECT 1 RN__,SQL_PAGING.* FROM (";
    private static final String SUBQUERY_END = ") SQL_PAGING";
    private static final String ORDER_BY = " ORDER BY RN__";
    private static final String PAGE_WRAP_END = " OFFSET %d ROW FETCH NEXT %d ROW ONLY";
    private static final SQLServerPagingDialect INSTANCE = new SQLServerPagingDialect();

    public static final SQLServerPagingDialect getInstance() {
        return INSTANCE;
    }

    protected SQLServerPagingDialect() {
    }

    @Override
    public String countSql(String namedSql, SQLMetaData sqlMetaData) {
        int selectIndex = sqlMetaData.getSelectIndex();
        int offsetIndex = sqlMetaData.getOffsetIndex();
        if (selectIndex >= 0) {
            if (offsetIndex > selectIndex) {
                return SQLServerPagingDialect.wrapCountSql(namedSql, selectIndex, sqlMetaData.getOrderByIndex(), offsetIndex);
            }
            int fetchIndex = sqlMetaData.getFetchIndex();
            if (offsetIndex > selectIndex) {
                return SQLServerPagingDialect.wrapCountSql(namedSql, selectIndex, sqlMetaData.getOrderByIndex(), fetchIndex);
            }
            int fromIndex = sqlMetaData.getFromIndex();
            if (fromIndex > selectIndex) {
                int columnsBegin = selectIndex + SELECT_LEN;
                if (namedSql.substring(columnsBegin, fromIndex).matches("[\\s]*[C|c][O|o][U|u][N|n][T|t]\\([\\S]+\\)[\\s]*")) {
                    return namedSql;
                }
                String select = namedSql.substring(0, columnsBegin);
                int orderByIndex = sqlMetaData.getOrderByIndex();
                if (orderByIndex > fromIndex) {
                    return StringUtils.concat((String[])new String[]{select, COUNT, namedSql.substring(fromIndex, orderByIndex)});
                }
                return StringUtils.concat((String[])new String[]{select, COUNT, namedSql.substring(fromIndex)});
            }
            return StringUtils.concat((String[])new String[]{COUNT_START, namedSql, SUBQUERY_END});
        }
        return StringUtils.concat((String[])new String[]{COUNT_START, namedSql, SUBQUERY_END});
    }

    @Override
    public String pageSql(Connection con, String namedSql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) throws SQLException {
        int selectIndex = sqlMetaData.getSelectIndex();
        String pageEnd = SQLServerPagingDialect.pageEnd(pageSize, currentPage);
        if (selectIndex >= 0) {
            int offsetIndex = sqlMetaData.getOffsetIndex();
            if (offsetIndex > selectIndex) {
                return SQLServerPagingDialect.wrapPageSql(namedSql, SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), pageEnd, selectIndex, sqlMetaData.getOrderByIndex(), offsetIndex);
            }
            int fetchIndex = sqlMetaData.getFetchIndex();
            if (fetchIndex > selectIndex) {
                return SQLServerPagingDialect.wrapPageSql(namedSql, SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), pageEnd, selectIndex, sqlMetaData.getOrderByIndex(), fetchIndex);
            }
            int orderByIndex = sqlMetaData.getOrderByIndex();
            if (orderByIndex > 0) {
                return namedSql.concat(pageEnd);
            }
            int selectEndIndex = selectIndex + SELECT_LEN;
            return StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), namedSql.substring(selectIndex, selectEndIndex), CONST_RN, namedSql.substring(selectEndIndex), ORDER_BY, pageEnd, SUBQUERY_END});
        }
        return StringUtils.concat((String[])new String[]{SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), SUBQUERY_START, namedSql, SUBQUERY_END, ORDER_BY, pageEnd, SUBQUERY_END});
    }

    private static String wrapCountSql(String namedSql, int selectIndex, int orderByIndex, int firstStatementIndexAfterOrderby) {
        if (orderByIndex > selectIndex || firstStatementIndexAfterOrderby < selectIndex) {
            namedSql = StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex), SUBQUERY_END});
        } else {
            int selectEndIndex = selectIndex + SELECT_LEN;
            namedSql = StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex, selectEndIndex), CONST_RN, namedSql.substring(selectEndIndex, firstStatementIndexAfterOrderby), ORDER_BY, " ", namedSql.substring(firstStatementIndexAfterOrderby), SUBQUERY_END});
        }
        return namedSql;
    }

    private static String wrapPageSql(String namedSql, String pageStart, String pageEnd, int selectIndex, int orderByIndex, int firstStatementIndexAfterOrderby) {
        if (orderByIndex > selectIndex || firstStatementIndexAfterOrderby < selectIndex) {
            return StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), pageStart, SUBQUERY_START, namedSql.substring(selectIndex), SUBQUERY_END, ORDER_BY, pageEnd, SUBQUERY_END});
        }
        int selectEndIndex = selectIndex + SELECT_LEN;
        namedSql = StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), pageStart, namedSql.substring(selectIndex, selectEndIndex), CONST_RN, namedSql.substring(selectEndIndex, firstStatementIndexAfterOrderby), ORDER_BY, " ", namedSql.substring(firstStatementIndexAfterOrderby), SUBQUERY_END, ORDER_BY, pageEnd});
        return namedSql;
    }

    private static String pageStart(String[] columnLabels) {
        return String.format(PAGE_WRAP_START, String.join((CharSequence)", ", columnLabels));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return String.format(PAGE_WRAP_END, (currentPage - 1L) * (long)pageSize, pageSize);
    }
}

