/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dao;

import cn.tenmg.sqltool.DSQLFactory;
import cn.tenmg.sqltool.dao.AbstractDao;
import cn.tenmg.sqltool.datasource.DataSourceFactory;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.InitializeDataSourceException;
import cn.tenmg.sqltool.factory.XMLFileDSQLFactory;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class BasicDao
extends AbstractDao {
    private static final String DATASOURCE_PREFIX = "sqltool.datasource.";
    private static final String DEFAULT_NAME = "default";
    private static final String DATASOURCE_REGEX = "^".concat("sqltool.datasource.".replaceAll("\\.", "\\\\.")).concat("([\\S]+\\.){0,1}[^\\.]+$");
    private static final int DATASOURCE_PREFIX_LEN = "sqltool.datasource.".length();
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private DataSource defaultDataSource = null;
    private DSQLFactory dsqlFactory;
    private boolean showSql;
    private int defaultBatchSize = 500;

    private BasicDao(Properties properties) {
        Properties datasourceConfig;
        String basePackages = properties.getProperty("sqltool.basePackages");
        String suffix = properties.getProperty("sqltool.suffix");
        this.dsqlFactory = suffix == null ? new XMLFileDSQLFactory(basePackages) : new XMLFileDSQLFactory(basePackages, suffix);
        this.showSql = Boolean.valueOf(properties.getProperty("sqltool.showSql", "false"));
        this.defaultBatchSize = Integer.valueOf(properties.getProperty("sqltool.defaultBatchSize", "500"));
        HashMap<String, Properties> datasourceConfigs = new HashMap<String, Properties>();
        String firstName = null;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name;
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (!key.matches(DATASOURCE_REGEX)) continue;
            String param = key.substring(DATASOURCE_PREFIX_LEN);
            int index = param.indexOf(".");
            if (index > 0) {
                name = param.substring(0, index);
                param = param.substring(index);
            } else {
                name = DEFAULT_NAME;
            }
            if (firstName == null) {
                firstName = name;
            }
            if ((datasourceConfig = (Properties)datasourceConfigs.get(name)) == null) {
                datasourceConfig = new Properties();
                datasourceConfigs.put(name, datasourceConfig);
            }
            datasourceConfig.put(param, value);
        }
        if (CollectionUtils.isEmpty(datasourceConfigs)) {
            throw new IllegalConfigException("No datasource is configured, please check the configuration");
        }
        String defaultName = DEFAULT_NAME;
        datasourceConfig = (Properties)datasourceConfigs.get(DEFAULT_NAME);
        if (datasourceConfig == null) {
            defaultName = firstName;
            datasourceConfig = (Properties)datasourceConfigs.get(firstName);
        }
        try {
            this.defaultDataSource = DataSourceFactory.createDataSource(datasourceConfig);
            this.dataSources.put(defaultName, this.defaultDataSource);
            DIALECTS.put(this.defaultDataSource, SQLDialectUtils.getSQLDialect(datasourceConfig));
            datasourceConfigs.remove(defaultName);
            for (Map.Entry entry : datasourceConfigs.entrySet()) {
                datasourceConfig = (Properties)entry.getValue();
                DataSource dataSource = DataSourceFactory.createDataSource(datasourceConfig);
                this.dataSources.put((String)entry.getKey(), dataSource);
                DIALECTS.put(dataSource, SQLDialectUtils.getSQLDialect(datasourceConfig));
            }
        }
        catch (Exception e) {
            throw new InitializeDataSourceException("An exception occurred while initializing datasource(s)", e);
        }
    }

    public static BasicDao build(Properties properties) {
        return new BasicDao(properties);
    }

    @Override
    public DSQLFactory getDSQLFactory() {
        return this.dsqlFactory;
    }

    @Override
    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dataSources.get(name);
    }

    @Override
    boolean isShowSql() {
        return this.showSql;
    }

    @Override
    int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }
}

