/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.datasource;

import cn.tenmg.sqltool.datasource.DatasourceBuilder;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import java.util.Properties;
import javax.sql.DataSource;

public final class DataSourceFactory {
    public static final String TYPE_NAME = "type";
    public static final String DEFAULT_TYPE = "com.alibaba.druid.pool.DruidDataSource";
    public static final String BUILDER_PREFIX = "cn.tenmg.sqltool.datasource.builder.";
    public static final String BUILDER_SUFFIX = "Builder";

    private DataSourceFactory() {
    }

    public static DataSource createDataSource(Properties properties) throws Exception {
        String type = properties.getProperty(TYPE_NAME, DEFAULT_TYPE);
        String buildName = BUILDER_PREFIX.concat(type).concat(BUILDER_SUFFIX);
        try {
            Class<?> datasourceBuilder = Class.forName(buildName);
            return ((DatasourceBuilder)datasourceBuilder.newInstance()).createDataSource(properties);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException("This type of datasource is not supported at the moment: " + type, e);
        }
    }
}

