/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.sql.SQLMetaData;
import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MySQLDialect
extends AbstractSQLDialect {
    private static final long serialVersionUID = 7189284927835898553L;
    private static final String UPDATE_SET_TEMPLATE = "${columnName} = ?";
    private static final String UPDATE_SET_IF_NOT_NULL_TEMPLATE = "${columnName} = IFNULL(?, ${columnName})";
    private static final String INSERT_IF_NOT_EXISTS = "INSERT IGNORE INTO ${tableName} (${columns}) VALUES (${values})";
    private static final String SAVE = "INSERT INTO ${tableName} (${columns}) VALUES (${values}) ON DUPLICATE KEY UPDATE ${sets}";
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("columns", "values");
    private static final String SET_TEMPLATE = "${columnName} = VALUES(${columnName})";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "${columnName} = IFNULL(VALUES(${columnName}), ${columnName})";
    private static final String PAGE_WRAP_START = "SELECT * FROM (\n";
    private static final String PAGE_WRAP_END = "\n) SQLTOOL";
    private static final String LIMIT = " LIMIT %d,%d";

    public static final MySQLDialect getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private MySQLDialect() {
    }

    @Override
    String getUpdateSetTemplate() {
        return UPDATE_SET_TEMPLATE;
    }

    @Override
    String getUpdateSetIfNotNullTemplate() {
        return UPDATE_SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return null;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append('?');
    }

    @Override
    void handleIdColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    public String pageSql(String sql, SQLMetaData sqlMetaData, int pageSize, long currentPage) {
        int length = sqlMetaData.getLength();
        int embedStartIndex = sqlMetaData.getEmbedStartIndex();
        int embedEndIndex = sqlMetaData.getEmbedEndIndex();
        if (sqlMetaData.getLimitIndex() >= 0) {
            if (embedStartIndex > 0) {
                if (embedEndIndex < length) {
                    return sql.substring(0, embedStartIndex).concat(PAGE_WRAP_START).concat(sql.substring(embedStartIndex, embedEndIndex)).concat(MySQLDialect.pageEnd(pageSize, currentPage)).concat(sql.substring(embedEndIndex));
                }
                return sql.substring(0, embedStartIndex).concat(PAGE_WRAP_START).concat(sql.substring(embedStartIndex)).concat(MySQLDialect.pageEnd(pageSize, currentPage));
            }
            if (embedEndIndex < length) {
                return PAGE_WRAP_START.concat(sql.substring(0, embedEndIndex)).concat(MySQLDialect.pageEnd(pageSize, currentPage)).concat(sql.substring(embedEndIndex));
            }
            return PAGE_WRAP_START.concat(sql).concat(MySQLDialect.pageEnd(pageSize, currentPage));
        }
        if (embedEndIndex > 0 && embedEndIndex < length) {
            return sql.substring(0, embedEndIndex).concat(MySQLDialect.generateLimit(pageSize, currentPage)).concat(sql.substring(embedEndIndex));
        }
        return sql.concat(MySQLDialect.generateLimit(pageSize, currentPage));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return PAGE_WRAP_END.concat(MySQLDialect.generateLimit(pageSize, currentPage));
    }

    private static String generateLimit(int pageSize, long currentPage) {
        return String.format(LIMIT, (currentPage - 1L) * (long)pageSize, pageSize);
    }

    private static class InstanceHolder {
        private static final MySQLDialect INSTANCE = new MySQLDialect();

        private InstanceHolder() {
        }
    }
}

