/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.utils;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.SQLMetaData;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class SQLUtils {
    private static final String WITH = "WITH";
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String FROM_REVERSE = "MORF";
    private static final String ON_REVERSE = "NO";
    private static final String WHERE_REVERSE = "EREHW";
    private static final String GROUP_REVERSE = "PUORG";
    private static final String ORDER_REVERSE = "REDRO";
    private static final String BY_REVERSE = "YB";
    private static final String LIMIT_REVERSE = "TIMIL";
    private static final String MIN_SQL = "SELECT * FROM T";
    private static final String SELECT_SQL_TPL = "SELECT %s FROM %s%s";
    private static final String SPACE_WHERE_SPACE = " WHERE ";
    private static final int MIN_SQL_LEN = "SELECT * FROM T".length();
    private static final int MIN_LEN = "SELECT * FROM T".concat(" LIMIT 1").length();
    private static final char BLANK_SPACE = ' ';
    private static final char LEFT_BRACKET = '(';
    private static final char RIGHT_BRACKET = ')';
    private static final char SINGLE_QUOTATION_MARK = '\'';
    private static final char[] LINE_SEPARATOR = new char[]{'\r', '\n'};

    public static DML getCachedDML(String key) {
        return (DML)DMLCacheHolder.CACHE.get(key);
    }

    public static synchronized void cacheDML(String key, DML dml) {
        DMLCacheHolder.CACHE.put(key, dml);
    }

    public static <T> SQL parseSelect(T obj) {
        StringBuilder columns = new StringBuilder();
        StringBuilder criteria = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        boolean hasColumn = false;
        boolean hasWhere = false;
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        try {
            if (entityMeta == null) {
                Class<?> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<Field> fields = new ArrayList<Field>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        fields.add(field);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                        } else {
                            fieldMeta.setId(true);
                        }
                        Object param = field.get(obj);
                        if (param != null) {
                            params.add(param);
                            if (hasWhere) {
                                criteria.append(" AND ");
                            } else {
                                hasWhere = true;
                                criteria.append(SPACE_WHERE_SPACE);
                            }
                            criteria.append(columnName).append(" = ").append('?');
                        }
                        if (hasColumn) {
                            columns.append(", ");
                        } else {
                            hasColumn = true;
                        }
                        columns.append(columnName);
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                EntityUtils.cacheEntityMeta(type, new EntityMeta(EntityUtils.getTableName(type), fieldMetas));
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Object param = fieldMeta.getField().get(obj);
                    if (param != null) {
                        params.add(param);
                        if (hasWhere) {
                            criteria.append(" AND ");
                        } else {
                            hasWhere = true;
                            criteria.append(SPACE_WHERE_SPACE);
                        }
                        criteria.append(columnName).append(" = ").append('?');
                    }
                    if (hasColumn) {
                        columns.append(", ");
                    } else {
                        hasColumn = true;
                    }
                    columns.append(columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (hasColumn) {
            return new SQL(String.format(SELECT_SQL_TPL, columns, EntityUtils.getTableName(type), criteria), params);
        }
        throw new PkNotFoundException("Column not found in class ".concat(type.getName()).concat(", please use @Column to config"));
    }

    public static SQLMetaData getSqlMetaData(String sql) {
        SQLMetaData sqlMetaData = new SQLMetaData();
        int len = sql.length();
        sqlMetaData.setLength(len);
        if (len <= MIN_SQL_LEN) {
            return sqlMetaData;
        }
        if (len >= MIN_LEN) {
            SQLUtils.rightAnalysis(sql, len, sqlMetaData);
        }
        SQLUtils.leftAnalysis(sql, len, sqlMetaData);
        return sqlMetaData;
    }

    public static boolean isStringEnd(char a, char b, char c) {
        return (a == '\'' || a != '\'' && b != '\'') && c == '\'';
    }

    private static void rightAnalysis(String sql, int len, SQLMetaData sqlMetaData) {
        int i = len - 1;
        char c = sql.charAt(i);
        boolean isString = false;
        int[] lineSplitorIndexs = new int[]{len, len};
        StringBuilder sba = new StringBuilder();
        StringBuilder sbb = new StringBuilder();
        while (i > 0 && c <= ' ') {
            SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
            c = sql.charAt(--i);
        }
        SQLUtils.setEmbedEndIndex(sqlMetaData, lineSplitorIndexs[0], lineSplitorIndexs[1]);
        while (i > 0) {
            if (isString) {
                if (i <= 2) break;
                char b = sql.charAt(--i);
                if (i > 0 && SQLUtils.isStringEnd(sql.charAt(i - 1), b, c)) {
                    isString = false;
                }
                c = b;
                continue;
            }
            if (c == '\'') {
                isString = true;
                c = sql.charAt(--i);
                continue;
            }
            if (c <= ' ') {
                String sa = sba.toString();
                String sb = sbb.toString();
                if (i >= MIN_SQL_LEN) {
                    if (BY_REVERSE.equalsIgnoreCase(sa)) {
                        if (GROUP_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setGroupByIndex(i + 1);
                            break;
                        }
                        if (ORDER_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setOrderByIndex(i + 1);
                        }
                    } else if (LIMIT_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setLimitIndex(i + 1);
                    } else {
                        if (WHERE_REVERSE.equalsIgnoreCase(sb) || ON_REVERSE.equalsIgnoreCase(sb)) break;
                        if (FROM_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setFromIndex(i + 1);
                            break;
                        }
                    }
                } else {
                    if (WHERE_REVERSE.equalsIgnoreCase(sb) || ON_REVERSE.equalsIgnoreCase(sb)) break;
                    if (FROM_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setFromIndex(i + 1);
                        break;
                    }
                }
                sba = sbb;
                sbb = new StringBuilder();
            } else {
                sbb.append(c);
            }
            c = sql.charAt(--i);
        }
    }

    private static void leftAnalysis(String sql, int len, SQLMetaData sqlMetaData) {
        int i = 0;
        int deep = 0;
        int max = len;
        int fromIndex = sqlMetaData.getFromIndex();
        if (fromIndex > 0 && max > fromIndex) {
            max = fromIndex;
        }
        int[] lineSplitorIndexs = new int[]{-1, -1};
        char[] charsBefore = new char[]{' ', ' '};
        boolean isString = false;
        boolean isWith = false;
        StringBuilder sb = new StringBuilder();
        while (i < max) {
            String s;
            char c = sql.charAt(i);
            if (isWith) {
                if (isString) {
                    if (SQLUtils.isStringEnd(charsBefore[0], charsBefore[1], c)) {
                        isString = false;
                    }
                    i = SQLUtils.stepForward(charsBefore, c, i);
                    continue;
                }
                if (c == '\'') {
                    isString = true;
                    i = SQLUtils.stepForward(charsBefore, c, i);
                    continue;
                }
                if (c == '(') {
                    ++deep;
                } else if (c == ')') {
                    if (--deep == 0) {
                        sb.setLength(0);
                    } else if (deep < 0) {
                        break;
                    }
                } else if (c <= ' ') {
                    if (deep == 0) {
                        SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
                        s = sb.toString();
                        if (SELECT.equalsIgnoreCase(s)) {
                            sqlMetaData.setSelectIndex(i - SELECT.length());
                            isWith = false;
                        }
                        sb.setLength(0);
                    }
                } else {
                    sb.append(c);
                }
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (isString) {
                if (SQLUtils.isStringEnd(charsBefore[0], charsBefore[1], c)) {
                    isString = false;
                }
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (c == '\'') {
                isString = true;
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (c <= ' ') {
                SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
                s = sb.toString();
                if (SELECT.equalsIgnoreCase(s)) {
                    sqlMetaData.setSelectIndex(i - SELECT.length());
                    if (fromIndex > 0) {
                        break;
                    }
                } else {
                    if (FROM.equalsIgnoreCase(s)) {
                        sqlMetaData.setFromIndex(i - FROM.length());
                        break;
                    }
                    if (WITH.equalsIgnoreCase(s)) {
                        isWith = true;
                    }
                }
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            i = SQLUtils.stepForward(charsBefore, c, i);
        }
        SQLUtils.setEmbedStartIndex(sqlMetaData, lineSplitorIndexs[0], lineSplitorIndexs[1]);
    }

    private static int stepForward(char[] charsBefore, char c, int i) {
        charsBefore[0] = charsBefore[1];
        charsBefore[1] = c;
        return ++i;
    }

    private static void decideLineSplitorIndex(int[] lineSplitorIndexs, char c, int i) {
        if (c == LINE_SEPARATOR[1]) {
            lineSplitorIndexs[1] = i;
        } else if (c == LINE_SEPARATOR[0]) {
            lineSplitorIndexs[0] = i;
        }
    }

    private static void setEmbedStartIndex(SQLMetaData sqlMetaData, int r, int n) {
        if (r < n) {
            if (n <= sqlMetaData.getSelectIndex()) {
                sqlMetaData.setEmbedStartIndex(n + 1);
                return;
            }
        } else if (r > n && r <= sqlMetaData.getSelectIndex()) {
            sqlMetaData.setEmbedStartIndex(r + 1);
            return;
        }
        sqlMetaData.setEmbedStartIndex(sqlMetaData.getSelectIndex());
    }

    private static void setEmbedEndIndex(SQLMetaData sqlMetaData, int r, int n) {
        if (r < n) {
            if (r <= sqlMetaData.getLength()) {
                sqlMetaData.setEmbedEndIndex(r);
                return;
            }
        } else if (r > n && n <= sqlMetaData.getLength()) {
            sqlMetaData.setEmbedEndIndex(n);
            return;
        }
        sqlMetaData.setEmbedEndIndex(sqlMetaData.getLength());
    }

    private static final class DMLCacheHolder {
        private static volatile Map<String, DML> CACHE = new HashMap<String, DML>();

        private DMLCacheHolder() {
        }
    }
}

