/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.transaction;

import cn.tenmg.sqltool.DSQLFactory;
import cn.tenmg.sqltool.dsql.NamedSQL;
import cn.tenmg.sqltool.dsql.utils.DSQLUtils;
import cn.tenmg.sqltool.exception.SQLException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransactionExecutor
implements Serializable {
    private static final long serialVersionUID = -4415310449248911047L;
    private static final Logger log = Logger.getLogger(TransactionExecutor.class);
    private boolean showSql = true;
    private DSQLFactory dsqlFactory;
    private SQLDialect dialect;

    public TransactionExecutor(boolean showSql, DSQLFactory dsqlFactory, SQLDialect dialect) {
        this.showSql = showSql;
        this.dsqlFactory = dsqlFactory;
        this.dialect = dialect;
    }

    public int insert(Object obj) {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        String sql = dml.getSql();
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        if (this.showSql) {
            StringBuilder sb = new StringBuilder();
            sb.append("Execute SQL: ").append(sql).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
            log.info((Object)sb.toString());
        }
        try {
            return JdbcUtils.execute(CurrentConnectionHolder.get(), sql, params, ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int insert(List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        DML dml = InsertDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
        String sql = dml.getSql();
        if (this.showSql) {
            log.info((Object)"Execute SQL: ".concat(sql));
        }
        try {
            return JdbcUtils.insert(CurrentConnectionHolder.get(), this.showSql, rows);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int update(T obj) {
        SQL sql = this.dialect.update(obj);
        try {
            return JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int update(T obj, String ... hardFields) {
        SQL sql = this.dialect.update(obj, hardFields);
        try {
            return JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int update(List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        try {
            return JdbcUtils.update(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.update(((Serializable)rows.get(0)).getClass()));
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int update(List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        try {
            return JdbcUtils.update(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.update(((Serializable)rows.get(0)).getClass(), hardFields));
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> int hardUpdate(Map<String, String> options, T obj) {
        int n;
        PreparedStatement ps;
        block10: {
            DML dml = UpdateDMLParser.getInstance().parse(obj.getClass());
            ps = null;
            try {
                String sql = dml.getSql();
                ps = CurrentConnectionHolder.get().prepareStatement(sql);
                List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
                JdbcUtils.setParams(ps, params);
                if (this.showSql) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Execute SQL: ").append(sql).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                    log.info((Object)sb.toString());
                }
                n = ps.executeUpdate();
                if (ps == null) break block10;
            }
            catch (java.sql.SQLException e) {
                try {
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (java.sql.SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (java.sql.SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    public <T extends Serializable> int hardUpdate(List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        try {
            return JdbcUtils.hardUpdate(CurrentConnectionHolder.get(), this.showSql, rows);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int save(T obj) {
        SQL sql = this.dialect.save(obj);
        try {
            return JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int save(T obj, String ... hardFields) {
        SQL sql = this.dialect.save(obj, hardFields);
        try {
            return JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int save(List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        try {
            return JdbcUtils.save(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.save(((Serializable)rows.get(0)).getClass()));
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int save(List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        try {
            return JdbcUtils.save(CurrentConnectionHolder.get(), this.showSql, rows, this.dialect.save(((Serializable)rows.get(0)).getClass(), hardFields));
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int hardSave(T obj) {
        SQL sql = this.dialect.hardSave(obj);
        try {
            return JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance(), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> int hardSave(List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        try {
            return JdbcUtils.hardSave(CurrentConnectionHolder.get(), this.dialect, this.showSql, rows);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> T get(T obj) {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        try {
            return (T)((Serializable)JdbcUtils.execute(CurrentConnectionHolder.get(), dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSQLExecuter(type), this.showSql));
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) {
        return this.get(this.dsqlFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) {
        return this.get(this.dsqlFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) {
        return this.select(this.dsqlFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) {
        return this.select(this.dsqlFactory.parse(dsql, params), type);
    }

    public boolean execute(String dsql, Object ... params) {
        return this.execute(this.dsqlFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, ?> params) {
        return this.execute(this.dsqlFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) {
        return this.executeUpdate(this.dsqlFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, ?> params) {
        return this.executeUpdate(this.dsqlFactory.parse(dsql, params));
    }

    private boolean execute(NamedSQL namedSQL) {
        SQL sql = DSQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        PreparedStatement ps = null;
        boolean rs = false;
        Connection con = CurrentConnectionHolder.get();
        try {
            String script = sql.getScript();
            List<Object> params = sql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, sql.getParams());
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            rs = ps.execute();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return rs;
    }

    private int executeUpdate(NamedSQL namedSQL) {
        SQL sql = DSQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        PreparedStatement ps = null;
        int count = 0;
        Connection con = CurrentConnectionHolder.get();
        try {
            String script = sql.getScript();
            List<Object> params = sql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, params);
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            count = ps.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return count;
    }

    private <T extends Serializable> T get(NamedSQL namedSQL, Class<T> type) {
        SQL sql = DSQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        try {
            return (T)((Serializable)JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), new GetSQLExecuter<T>(type), this.showSql));
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    private <T extends Serializable> List<T> select(NamedSQL namedSQL, Class<T> type) {
        SQL sql = DSQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        try {
            return (List)JdbcUtils.execute(CurrentConnectionHolder.get(), sql.getScript(), sql.getParams(), new SelectSQLExecuter<T>(type), this.showSql);
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }
}

