/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class StringUtils {
    private static final String EMPTY = "";
    private static final int INDEX_NOT_FOUND = -1;
    private static final String UNDERLINE = "_";

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        int len;
        if (string == null || (len = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimToEmpty(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String trimToNull(String string) {
        String r = StringUtils.trim(string);
        return StringUtils.isEmpty(r) ? null : r;
    }

    public static String strip(String string, String stripChars) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        string = StringUtils.stripStart(string, stripChars);
        return StringUtils.stripEnd(string, stripChars);
    }

    public static String stripStart(String string, String stripChars) {
        int start;
        int strLen;
        if (string == null || (strLen = string.length()) == 0) {
            return string;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(string.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return string;
            }
            while (start != strLen && stripChars.indexOf(string.charAt(start)) != -1) {
                ++start;
            }
        }
        return string.substring(start);
    }

    public static String stripEnd(String string, String stripChars) {
        int end;
        if (string == null || (end = string.length()) == 0) {
            return string;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(string.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return string;
            }
            while (end != 0 && stripChars.indexOf(string.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return string.substring(0, end);
    }

    public static String[] stripAll(String[] strings) {
        return StringUtils.stripAll(strings, null);
    }

    public static String[] stripAll(String[] strings, String stripChars) {
        int strsLen;
        if (strings == null || (strsLen = strings.length) == 0) {
            return strings;
        }
        String[] newStrings = new String[strsLen];
        for (int i = 0; i < strsLen; ++i) {
            newStrings[i] = StringUtils.strip(strings[i], stripChars);
        }
        return newStrings;
    }

    public static boolean equals(String string, String anotherString) {
        return string == null ? anotherString == null : string.equals(anotherString);
    }

    public static boolean equalsIgnoreCase(String string, String anotherString) {
        return string == null ? anotherString == null : string.equalsIgnoreCase(anotherString);
    }

    public static int indexOf(String string, char ch) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(ch);
    }

    public static int indexOf(String string, char ch, int fromIndex) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(ch, fromIndex);
    }

    public static int indexOf(String string, String searchString) {
        if (string == null || searchString == null) {
            return -1;
        }
        return string.indexOf(searchString);
    }

    public static int indexOf(String string, String searchString, int fromIndex) {
        if (string == null || searchString == null) {
            return -1;
        }
        if (searchString.length() == 0 && fromIndex >= string.length()) {
            return string.length();
        }
        return string.indexOf(searchString, fromIndex);
    }

    public static int indexOfIgnoreCase(String string, String searchString) {
        return StringUtils.indexOfIgnoreCase(string, searchString, 0);
    }

    public static int indexOfIgnoreCase(String string, String searchString, int formIndex) {
        int endLimit;
        if (string == null || searchString == null) {
            return -1;
        }
        if (formIndex < 0) {
            formIndex = 0;
        }
        if (formIndex > (endLimit = string.length() - searchString.length() + 1)) {
            return -1;
        }
        if (searchString.length() == 0) {
            return formIndex;
        }
        for (int i = formIndex; i < endLimit; ++i) {
            if (!string.regionMatches(true, i, searchString, 0, searchString.length())) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String string, String searchString, int ordinal) {
        return StringUtils.ordinalIndexOf(string, searchString, ordinal, false);
    }

    public static int ordinalIndexOf(String string, String searchString, int ordinal, boolean reverse) {
        if (string == null || searchString == null || ordinal <= 0) {
            return -1;
        }
        if (searchString.length() == 0) {
            return reverse ? string.length() : 0;
        }
        int found = 0;
        int index = reverse ? string.length() : -1;
        do {
            if ((index = reverse ? string.lastIndexOf(searchString, index - 1) : string.indexOf(searchString, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static List<Integer> toIntegerList(String string, String regex) {
        String[] strings;
        if (StringUtils.isBlank(string) || StringUtils.isBlank(regex)) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : strings = string.split(regex)) {
            result.add(Integer.valueOf(s));
        }
        return result;
    }

    public static List<String> toStringList(String string, String regex) {
        String[] strings;
        if (StringUtils.isBlank(string) || StringUtils.isBlank(regex)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strings = string.split(regex)) {
            result.add(s);
        }
        return result;
    }

    public static boolean isNumber(String string) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(string).matches();
    }

    public static String toCamelCase(String string, String regex, boolean isUpperCase) {
        if (StringUtils.isBlank(string)) {
            return string;
        }
        if (regex == null) {
            string = string.substring(0, 1).toUpperCase().concat(string.substring(1, string.length()).toLowerCase());
        } else {
            String[] items = string.split(regex);
            string = EMPTY;
            for (String item : items) {
                string = string.concat(item.substring(0, 1).toUpperCase()).concat(item.substring(1, item.length()).toLowerCase());
            }
        }
        if (!isUpperCase) {
            string = string.substring(0, 1).toLowerCase().concat(string.substring(1, string.length()));
        }
        return string;
    }

    public static String reverse(String string) {
        if (string == null) {
            return string;
        }
        return new StringBuilder(string).reverse().toString();
    }

    public static String camelToUnderline(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append(UNDERLINE);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelToUnderline(String s, boolean upperOrLowerCace) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append(UNDERLINE);
            }
            if (upperOrLowerCace) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

