/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dsql.filter;

import cn.tenmg.sqltool.config.model.Filter;
import cn.tenmg.sqltool.config.model.filter.Gt;
import cn.tenmg.sqltool.dsql.filter.ParamFilter;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.DateUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GtParamFilter
implements ParamFilter {
    private static final String ZERO = "0";
    private static final String DATE_REGEX = "(-| |/|:)";
    private static final String DATE_PATTERN = "yyyyMMddHHmmss";
    private static final int DATE_PATTERN_LENGTH = "yyyyMMddHHmmss".length();
    private static final String TIME_REGEX = ":";
    private static final String TIME_PATTERN = "HHmmss";
    private static final int TIME_PATTERN_LENGTH = "HHmmss".length();

    @Override
    public void doFilter(Filter filter, Map<String, ?> params) {
        List<Gt> gts = filter.getGts();
        if (CollectionUtils.isEmpty(gts)) {
            return;
        }
        block0: for (Gt gt : gts) {
            String paramsConfig = gt.getParams();
            String value = gt.getValue();
            if (!StringUtils.isNotBlank(value) || !StringUtils.isNotBlank(paramsConfig)) continue;
            String[] paramNames = paramsConfig.split(",");
            for (int i = 0; i < paramNames.length; ++i) {
                String paramName = paramNames[i].trim();
                if ("*".equals(paramName)) {
                    this.doFilter(value, params);
                    continue block0;
                }
                if (!params.containsKey(paramName)) continue;
                this.doFilter(paramName, value, params);
            }
        }
    }

    private void doFilter(String value, Map<String, ?> params) {
        Iterator<Map.Entry<String, ?>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ?> entry = it.next();
            Object paramValue = entry.getValue();
            if (paramValue == null || !this.isFiltered(paramValue, value)) continue;
            it.remove();
        }
    }

    private void doFilter(String paramName, String value, Map<String, ?> params) {
        Object paramValue = params.get(paramName);
        if (paramValue != null && this.isFiltered(paramValue, value)) {
            params.remove(paramName);
        }
    }

    private boolean isFiltered(Object paramValue, String value) {
        if (paramValue != null) {
            if (paramValue instanceof String) {
                if (value.compareTo((String)paramValue) < 0) {
                    return true;
                }
            } else {
                if (paramValue instanceof Date || paramValue instanceof java.sql.Date || paramValue instanceof Timestamp) {
                    return this.isDateFiltered(paramValue, value);
                }
                if (paramValue instanceof Time) {
                    if (StringUtils.isNumber(value = value.replaceAll(TIME_REGEX, ""))) {
                        for (int j = value.length(); j < TIME_PATTERN_LENGTH; ++j) {
                            value = value.concat(ZERO);
                        }
                        if (value.compareTo(DateUtils.format(paramValue, DATE_PATTERN)) < 0) {
                            return true;
                        }
                    }
                } else {
                    if (paramValue instanceof Calendar) {
                        return this.isDateFiltered(paramValue, value);
                    }
                    if (value.compareTo(paramValue.toString()) < 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isDateFiltered(Object paramValue, String value) {
        if (StringUtils.isNumber(value = value.replaceAll(DATE_REGEX, ""))) {
            for (int j = value.length(); j < DATE_PATTERN_LENGTH; ++j) {
                value = value.concat(ZERO);
            }
            if (value.compareTo(DateUtils.format(paramValue, DATE_PATTERN)) < 0) {
                return true;
            }
        }
        return false;
    }
}

