/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dsql.utils;

import cn.tenmg.sqltool.dsql.NamedSQL;
import cn.tenmg.sqltool.dsql.utils.MacroUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DSQLUtils {
    private static final char BLANK_SPACE = ' ';
    private static final char PARAM_BEGIN = ':';
    private static final String LINE_SPLITOR = "\r\n";
    private static final String EMPTY_CHARS = "\r\n".concat("\t ");

    public static NamedSQL parse(String source, Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank(source)) {
            return new NamedSQL(source, params);
        }
        source = StringUtils.stripStart(source, LINE_SPLITOR);
        int len = (source = StringUtils.stripEnd(source, EMPTY_CHARS)).length();
        if (len < 3) {
            return new NamedSQL(source, params);
        }
        int deep = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isDynamic = false;
        boolean isParam = false;
        StringBuilder sql = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        HashMap<String, Object> usedParams = new HashMap<String, Object>();
        HashMap<Integer, Boolean> inValidMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, Set<String>> validMap = new HashMap<Integer, Set<String>>();
        HashMap<Integer, StringBuilder> dsqlMap = new HashMap<Integer, StringBuilder>();
        HashMap<Integer, Map<String, Object>> contexts = new HashMap<Integer, Map<String, Object>>();
        for (int i = 0; i < len; ++i) {
            String name;
            char c = source.charAt(i);
            if (isString) {
                if (DSQLUtils.isStringEnd(a, b, c)) {
                    isString = false;
                }
                if (deep > 0) {
                    ((StringBuilder)dsqlMap.get(deep)).append(c);
                } else {
                    sql.append(c);
                }
            } else if (c == '\'') {
                isString = true;
                if (deep > 0) {
                    ((StringBuilder)dsqlMap.get(deep)).append(c);
                } else {
                    sql.append(c);
                }
            } else if (isDynamic) {
                StringBuilder dsql;
                Object value;
                if (DSQLUtils.isDynamicEnd(c)) {
                    if (isParam) {
                        isParam = false;
                        name = paramName.toString();
                        value = params.get(name);
                        if (value != null) {
                            ((Set)validMap.get(deep)).add(name);
                            paramName.setLength(0);
                        } else if (deep > 0) {
                            inValidMap.put(deep, Boolean.TRUE);
                        }
                    }
                    if (inValidMap.get(deep) == null) {
                        DSQLUtils.processDSQL(params, sql, dsqlMap, usedParams, inValidMap, validMap, contexts, deep, false);
                        --deep;
                    } else if (deep > 0) {
                        DSQLUtils.processDSQL(params, sql, dsqlMap, usedParams, inValidMap, validMap, contexts, deep, true);
                        --deep;
                    }
                    if (deep < 1) {
                        isDynamic = false;
                        DSQLUtils.deleteRedundantBlank(sql);
                    } else {
                        DSQLUtils.deleteRedundantBlank((StringBuilder)dsqlMap.get(deep));
                    }
                } else if (isParam) {
                    if (DSQLUtils.isParamChar(c)) {
                        paramName.append(c);
                        dsql = (StringBuilder)dsqlMap.get(deep);
                        if (dsql == null) {
                            dsql = new StringBuilder();
                            dsqlMap.put(deep, dsql);
                        }
                        dsql.append(c);
                    } else {
                        StringBuilder dsql2;
                        isParam = false;
                        name = paramName.toString();
                        value = params.get(name);
                        if (value != null) {
                            validMap.get(deep).add(name);
                        } else if (deep >= 0) {
                            inValidMap.put(deep, Boolean.TRUE);
                        }
                        paramName.setLength(0);
                        if (DSQLUtils.isDynamicBegin(b, c)) {
                            dsql2 = dsqlMap.get(deep);
                            dsql2.deleteCharAt(dsql2.length() - 1);
                            dsqlMap.put(++deep, new StringBuilder());
                            validMap.put(deep, new HashSet());
                        } else {
                            dsql2 = dsqlMap.get(deep);
                            if (dsql2 == null) {
                                dsql2 = new StringBuilder();
                                dsqlMap.put(deep, dsql2);
                            }
                            dsql2.append(c);
                        }
                    }
                } else if (DSQLUtils.isDynamicBegin(b, c)) {
                    dsql = (StringBuilder)dsqlMap.get(deep);
                    dsql.deleteCharAt(dsql.length() - 1);
                    dsqlMap.put(++deep, new StringBuilder());
                    validMap.put(deep, new HashSet());
                } else {
                    if (DSQLUtils.isParamBegin(b, c)) {
                        isParam = true;
                        paramName.setLength(0);
                        paramName.append(c);
                    }
                    if ((dsql = (StringBuilder)dsqlMap.get(deep)) == null) {
                        dsql = new StringBuilder();
                        dsqlMap.put(deep, dsql);
                    }
                    dsql.append(c);
                }
            } else if (DSQLUtils.isDynamicBegin(b, c)) {
                isDynamic = true;
                sql.deleteCharAt(sql.length() - 1);
                validMap.put(++deep, new HashSet());
            } else {
                if (isParam) {
                    if (DSQLUtils.isParamChar(c)) {
                        paramName.append(c);
                        if (i == len - 1) {
                            name = paramName.toString();
                            usedParams.put(name, params.get(name));
                        }
                    } else {
                        isParam = false;
                        name = paramName.toString();
                        usedParams.put(name, params.get(name));
                        if (i < len - 1) {
                            paramName.setLength(0);
                        }
                    }
                } else if (DSQLUtils.isParamBegin(b, c)) {
                    isParam = true;
                    paramName.setLength(0);
                    paramName.append(c);
                }
                sql.append(c);
            }
            a = b;
            b = c;
        }
        return new NamedSQL(sql.toString(), usedParams);
    }

    public static NamedSQL parse(String source, Object ... params) {
        Map<String, Object> paramsMap = new HashMap<String, Object>();
        if (params != null) {
            if (params.length == 1 && params[0] instanceof Map) {
                paramsMap = (Map)params[0];
            } else {
                for (int i = 0; i < params.length; ++i) {
                    paramsMap.put((String)params[i], params[++i]);
                }
            }
        }
        return DSQLUtils.parse(source, paramsMap);
    }

    public static boolean isParamBegin(char b, char c) {
        return b == ':' && DSQLUtils.is26LettersIgnoreCase(c);
    }

    public static boolean isParamChar(char c) {
        return DSQLUtils.is26LettersIgnoreCase(c) || c >= '0' && c <= '9' || c == '_' || c == '-';
    }

    public static boolean isStringEnd(char a, char b, char c) {
        return (a == '\'' || a != '\'' && b != '\'') && c == '\'';
    }

    private static final void processDSQL(Map<String, Object> params, StringBuilder sql, HashMap<Integer, StringBuilder> dsqlMap, Map<String, Object> usedParams, HashMap<Integer, Boolean> inValidMap, HashMap<Integer, Set<String>> validMap, HashMap<Integer, Map<String, Object>> contexts, int deep, boolean emptyWhenNoMacro) {
        Map<String, Object> context = contexts.get(deep);
        if (context == null) {
            context = new HashMap<String, Object>();
            contexts.put(deep, context);
        }
        StringBuilder dsql = MacroUtils.execute(dsqlMap.get(deep), context, params, emptyWhenNoMacro);
        if (deep == 1) {
            sql.append((CharSequence)dsql);
            for (String name : validMap.get(deep)) {
                if (usedParams.containsKey(name) || dsql.indexOf(':' + name) < 0) continue;
                usedParams.put(name, params.get(name));
            }
        } else {
            dsqlMap.get(deep - 1).append((CharSequence)dsql);
        }
        dsqlMap.remove(deep);
        validMap.remove(deep);
        inValidMap.remove(deep);
    }

    private static boolean isDynamicBegin(char b, char c) {
        return b == '#' && c == '[';
    }

    private static boolean isDynamicEnd(char c) {
        return c == ']';
    }

    private static void deleteRedundantBlank(StringBuilder target) {
        int length;
        int i = length = target.length();
        while (i > 0) {
            char ch;
            if ((ch = target.charAt(--i)) <= ' ') continue;
            target.delete(i + 1, length);
            break;
        }
    }

    private static boolean is26LettersIgnoreCase(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

