/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.utils;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.dsql.utils.DSQLUtils;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.SQLMetaData;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SQLUtils {
    private static final String WITH = "WITH";
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String FROM_REVERSE = "MORF";
    private static final String ON_REVERSE = "NO";
    private static final String WHERE_REVERSE = "EREHW";
    private static final String GROUP_REVERSE = "PUORG";
    private static final String ORDER_REVERSE = "REDRO";
    private static final String BY_REVERSE = "YB";
    private static final String LIMIT_REVERSE = "TIMIL";
    private static final String OFFSET_REVERSE = "TESFFO";
    private static final String FETCH_REVERSE = "HCTEF";
    private static final String SELECT_SQL_TPL = "SELECT %s FROM %s%s";
    private static final String SPACE_WHERE_SPACE = " WHERE ";
    private static final int WITH_LEN = "WITH".length();
    private static final int SELECT_LEN = "SELECT".length();
    private static final int FROM_LEN = "FROM".length();
    public static final char BLANK_SPACE = ' ';
    public static final char LEFT_BRACKET = '(';
    public static final char RIGHT_BRACKET = ')';
    public static final char COMMA = ',';
    public static final char SINGLE_QUOTATION_MARK = '\'';
    public static final char[] LINE_SEPARATOR = new char[]{'\r', '\n'};
    private static final String SELECT_ALL = "SELECT * FROM (\n";
    private static final String ALIAS = "\n) SQLTOOL";
    private static final String WHERE_IMPOSSIBLE = "\nWHERE 1=0";

    public static DML getCachedDML(String key) {
        return (DML)DMLCacheHolder.CACHE.get(key);
    }

    public static synchronized void cacheDML(String key, DML dml) {
        DMLCacheHolder.CACHE.put(key, dml);
    }

    public static <T> SQL parseSelect(T obj) {
        StringBuilder columns = new StringBuilder();
        StringBuilder criteria = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        boolean hasColumn = false;
        boolean hasWhere = false;
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        try {
            if (entityMeta == null) {
                Class<?> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<Field> fields = new ArrayList<Field>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        fields.add(field);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                        } else {
                            fieldMeta.setId(true);
                        }
                        Object param = field.get(obj);
                        if (param != null) {
                            params.add(param);
                            if (hasWhere) {
                                criteria.append(" AND ");
                            } else {
                                hasWhere = true;
                                criteria.append(SPACE_WHERE_SPACE);
                            }
                            criteria.append(columnName).append(" = ").append('?');
                        }
                        if (hasColumn) {
                            columns.append(", ");
                        } else {
                            hasColumn = true;
                        }
                        columns.append(columnName);
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                EntityUtils.cacheEntityMeta(type, new EntityMeta(EntityUtils.getTableName(type), fieldMetas));
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Object param = fieldMeta.getField().get(obj);
                    if (param != null) {
                        params.add(param);
                        if (hasWhere) {
                            criteria.append(" AND ");
                        } else {
                            hasWhere = true;
                            criteria.append(SPACE_WHERE_SPACE);
                        }
                        criteria.append(columnName).append(" = ").append('?');
                    }
                    if (hasColumn) {
                        columns.append(", ");
                    } else {
                        hasColumn = true;
                    }
                    columns.append(columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (hasColumn) {
            return new SQL(String.format(SELECT_SQL_TPL, columns, EntityUtils.getTableName(type), criteria), params);
        }
        throw new PkNotFoundException("Column not found in class ".concat(type.getName()).concat(", please use @Column to config"));
    }

    public static SQL toSQL(String source, Map<String, ?> params) {
        if (params == null) {
            params = new HashMap();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (StringUtils.isBlank(source)) {
            return new SQL(source, paramList);
        }
        int len = source.length();
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isParam = false;
        StringBuilder sql = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            if (isString) {
                if (SQLUtils.isStringEnd(a, b, c)) {
                    isString = false;
                }
                sql.append(c);
            } else if (c == '\'') {
                isString = true;
                sql.append(c);
            } else if (isParam) {
                if (DSQLUtils.isParamChar(c)) {
                    paramName.append(c);
                } else {
                    isParam = false;
                    SQLUtils.paramEnd(params, sql, paramName, paramList);
                    sql.append(c);
                }
            } else if (DSQLUtils.isParamBegin(b, c)) {
                isParam = true;
                paramName.setLength(0);
                paramName.append(c);
                sql.setCharAt(sql.length() - 1, '?');
            } else {
                sql.append(c);
            }
            a = b;
            b = c;
        }
        if (isParam) {
            SQLUtils.paramEnd(params, sql, paramName, paramList);
        }
        return new SQL(sql.toString(), paramList);
    }

    public static SQLMetaData getSQLMetaData(String sql) {
        SQLMetaData sqlMetaData = new SQLMetaData();
        sqlMetaData.setLength(sql.length());
        SQLUtils.rightAnalysis(sql, sqlMetaData);
        SQLUtils.leftAnalysis(sql, sqlMetaData);
        return sqlMetaData;
    }

    public static boolean isStringEnd(char a, char b, char c) {
        return (a == '\'' || a != '\'' && b != '\'') && c == '\'';
    }

    public static final String[] getColumnLabels(Connection con, String sql, Map<String, ?> params, SQLMetaData sqlMetaData) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String[] columnLabels = null;
        try {
            int length = sqlMetaData.getLength();
            int embedStartIndex = sqlMetaData.getEmbedStartIndex();
            int embedEndIndex = sqlMetaData.getEmbedEndIndex();
            String script = embedStartIndex > 0 ? (embedEndIndex < length ? sql.substring(0, embedStartIndex).concat(SELECT_ALL).concat(sql.substring(embedStartIndex, embedEndIndex)).concat(ALIAS).concat(WHERE_IMPOSSIBLE).concat(sql.substring(embedEndIndex)) : sql.substring(0, embedStartIndex).concat(SELECT_ALL).concat(sql.substring(embedStartIndex)).concat(ALIAS).concat(WHERE_IMPOSSIBLE)) : (embedEndIndex < length ? SELECT_ALL.concat(sql.substring(0, embedEndIndex)).concat(ALIAS).concat(WHERE_IMPOSSIBLE).concat(sql.substring(embedEndIndex)) : SELECT_ALL.concat(sql).concat(ALIAS).concat(WHERE_IMPOSSIBLE));
            SQL SQL2 = SQLUtils.toSQL(script, params);
            ps = con.prepareStatement(SQL2.getScript());
            JdbcUtils.setParams(ps, SQL2.getParams());
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            columnLabels = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnLabels[i - 1] = rsmd.getColumnLabel(i);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(ps);
        return columnLabels;
    }

    private static void paramEnd(Map<String, ?> params, StringBuilder sql, StringBuilder paramName, List<Object> paramList) {
        String name = paramName.toString();
        Object value = params.get(name);
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (CollectionUtils.isEmpty(collection)) {
                    paramList.add(null);
                } else {
                    boolean flag = false;
                    Iterator it = collection.iterator();
                    while (it.hasNext()) {
                        if (flag) {
                            sql.append(", ?");
                        } else {
                            flag = true;
                        }
                        paramList.add(it.next());
                    }
                }
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                if (objects.length == 0) {
                    paramList.add(null);
                } else {
                    for (int j = 0; j < objects.length; ++j) {
                        if (j > 0) {
                            sql.append(", ?");
                        }
                        paramList.add(objects[j]);
                    }
                }
            } else {
                paramList.add(value);
            }
        } else {
            paramList.add(value);
        }
    }

    private static void rightAnalysis(String sql, SQLMetaData sqlMetaData) {
        int length = sqlMetaData.getLength();
        int i = length - 1;
        char c = sql.charAt(i);
        boolean isString = false;
        int deep = 0;
        int[] lineSplitorIndexs = new int[]{length, length};
        StringBuilder sba = new StringBuilder();
        StringBuilder sbb = new StringBuilder();
        while (i > 0 && c <= ' ') {
            SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
            c = sql.charAt(--i);
        }
        SQLUtils.setEmbedEndIndex(sqlMetaData, lineSplitorIndexs[0], lineSplitorIndexs[1]);
        while (i > 0) {
            if (isString) {
                if (i <= 2) break;
                char b = sql.charAt(--i);
                if (i > 0 && SQLUtils.isStringEnd(sql.charAt(i - 1), b, c)) {
                    isString = false;
                }
                c = b;
                continue;
            }
            if (c == '\'') {
                isString = true;
                c = sql.charAt(--i);
                continue;
            }
            if (c == ')') {
                ++deep;
                sba.setLength(0);
                sba.setLength(0);
            } else if (c == '(') {
                --deep;
                sba.setLength(0);
                sba.setLength(0);
            } else if (deep == 0) {
                if (c == ',') {
                    sba.setLength(0);
                    sba.setLength(0);
                } else if (c <= ' ') {
                    String sa = sba.toString();
                    String sb = sbb.toString();
                    if (BY_REVERSE.equalsIgnoreCase(sa)) {
                        if (GROUP_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setGroupByIndex(i + 1);
                            break;
                        }
                        if (ORDER_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setOrderByIndex(i + 1);
                        }
                    } else if (LIMIT_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setLimitIndex(i + 1);
                    } else if (FETCH_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setFetchIndex(i + 1);
                    } else if (OFFSET_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setOffsetIndex(i + 1);
                    } else {
                        if (WHERE_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setWhereIndex(i + 1);
                            break;
                        }
                        if (ON_REVERSE.equalsIgnoreCase(sb)) break;
                        if (FROM_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setFromIndex(i + 1);
                            break;
                        }
                    }
                    sba = sbb;
                    sbb = new StringBuilder();
                } else {
                    sbb.append(c);
                }
            }
            c = sql.charAt(--i);
        }
    }

    private static void leftAnalysis(String sql, SQLMetaData sqlMetaData) {
        int i = 0;
        int deep = 0;
        int max = sqlMetaData.getLength();
        int fromIndex = sqlMetaData.getFromIndex();
        int whereIndex = sqlMetaData.getWhereIndex();
        if (whereIndex > 0) {
            max = whereIndex;
        } else if (fromIndex > 0) {
            max = fromIndex;
        }
        int[] lineSplitorIndexs = new int[]{0, 0};
        char[] charsBefore = new char[]{' ', ' '};
        boolean isString = false;
        boolean isWith = false;
        StringBuilder sb = new StringBuilder();
        while (i < max) {
            String s;
            char c = sql.charAt(i);
            if (isWith) {
                if (isString) {
                    if (SQLUtils.isStringEnd(charsBefore[0], charsBefore[1], c)) {
                        isString = false;
                    }
                    i = SQLUtils.stepForward(charsBefore, c, i);
                    continue;
                }
                if (c == '\'') {
                    isString = true;
                    i = SQLUtils.stepForward(charsBefore, c, i);
                    continue;
                }
                if (c == '(') {
                    ++deep;
                    sb.setLength(0);
                } else if (c == ')') {
                    --deep;
                    sb.setLength(0);
                } else if (c <= ' ') {
                    if (deep == 0) {
                        SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
                        s = sb.toString();
                        if (SELECT.equalsIgnoreCase(s)) {
                            sqlMetaData.setSelectIndex(i - SELECT_LEN);
                            isWith = false;
                        }
                    }
                    sb.setLength(0);
                } else {
                    sb.append(c);
                }
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (isString) {
                if (SQLUtils.isStringEnd(charsBefore[0], charsBefore[1], c)) {
                    isString = false;
                }
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (c == '\'') {
                isString = true;
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (c == '(') {
                ++deep;
                sb.setLength(0);
            } else if (c == ')') {
                --deep;
                sb.setLength(0);
            } else if (c <= ' ') {
                if (deep == 0) {
                    if (sqlMetaData.getSelectIndex() < 0) {
                        SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
                    }
                    if (SELECT.equalsIgnoreCase(s = sb.toString())) {
                        sqlMetaData.setSelectIndex(i - SELECT_LEN);
                    } else if (FROM.equalsIgnoreCase(s)) {
                        sqlMetaData.setFromIndex(i - FROM_LEN);
                    } else if (WITH.equalsIgnoreCase(s)) {
                        sqlMetaData.setWithIndex(i - WITH_LEN);
                        isWith = true;
                    }
                }
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            i = SQLUtils.stepForward(charsBefore, c, i);
        }
        SQLUtils.setEmbedStartIndex(sqlMetaData, lineSplitorIndexs[0], lineSplitorIndexs[1]);
    }

    private static int stepForward(char[] charsBefore, char c, int i) {
        charsBefore[0] = charsBefore[1];
        charsBefore[1] = c;
        return ++i;
    }

    private static void decideLineSplitorIndex(int[] lineSplitorIndexs, char c, int i) {
        if (c == LINE_SEPARATOR[1]) {
            lineSplitorIndexs[1] = i;
        } else if (c == LINE_SEPARATOR[0]) {
            lineSplitorIndexs[0] = i;
        }
    }

    private static void setEmbedStartIndex(SQLMetaData sqlMetaData, int r, int n) {
        int withIndex = sqlMetaData.getWithIndex();
        int selectIndex = sqlMetaData.getSelectIndex();
        if (selectIndex > 0) {
            if (withIndex >= 0 && selectIndex > withIndex) {
                sqlMetaData.setEmbedStartIndex(selectIndex);
            } else if (r < n && n < selectIndex) {
                sqlMetaData.setEmbedStartIndex(n + 1);
            } else if (r > n && r < selectIndex) {
                sqlMetaData.setEmbedStartIndex(r + 1);
            } else {
                sqlMetaData.setEmbedStartIndex(selectIndex);
            }
        } else {
            sqlMetaData.setEmbedStartIndex(0);
        }
    }

    private static void setEmbedEndIndex(SQLMetaData sqlMetaData, int r, int n) {
        if (r < n) {
            sqlMetaData.setEmbedEndIndex(r);
        } else if (r > n) {
            sqlMetaData.setEmbedEndIndex(n);
        } else {
            sqlMetaData.setEmbedEndIndex(sqlMetaData.getLength());
        }
    }

    private static final class DMLCacheHolder {
        private static volatile Map<String, DML> CACHE = new HashMap<String, DML>();

        private DMLCacheHolder() {
        }
    }
}

