/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.DMLParser;
import cn.tenmg.sqltool.sql.MergeSQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.UpdateSQL;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JdbcUtils {
    private static final Logger log = LogManager.getLogger(JdbcUtils.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String COMMA_SPACE = ", ";
    public static final String SPACE_AND_SPACE = " AND ";
    public static final String SPACE_EQ_SPACE = " = ";
    public static final char PARAM_MARK = '?';
    public static final char SINGLE_QUOTATION_MARK = '\'';

    private JdbcUtils() {
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                log.error("Could not close JDBC Connection", (Throwable)ex);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                log.error("Unexpected exception on closing JDBC Connection", ex);
                ex.printStackTrace();
            }
        }
    }

    public static void close(Statement stm) {
        if (stm != null) {
            try {
                stm.close();
            }
            catch (SQLException ex) {
                log.error("Could not close JDBC Statement", (Throwable)ex);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                log.error("Unexpected exception on closing JDBC Statement", ex);
                ex.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                log.error("Could not close JDBC ResultSet", (Throwable)ex);
            }
            catch (Throwable ex) {
                log.error("Unexpected exception on closing JDBC ResultSet", ex);
            }
        }
    }

    public static <T> List<Object> getParams(T obj, List<Field> fields) {
        ArrayList<Object> params = new ArrayList<Object>();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                params.add(fields.get(i).get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
        return params;
    }

    public static void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        if (!CollectionUtils.isEmpty(params)) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params.get(i));
            }
        }
    }

    public static <T> void setParams(PreparedStatement ps, T obj, List<Field> fields) throws SQLException {
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fields.get(i).get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
    }

    public static <T> void setParams(PreparedStatement ps, List<FieldMeta> fieldMetas, T obj) throws SQLException {
        int size = fieldMetas.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fieldMetas.get(i).getField().get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
    }

    public static <T> T getValue(ResultSet rs, int columnIndex, Class<T> type) throws SQLException {
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (T)rs.getBigDecimal(columnIndex);
        }
        if (Number.class.isAssignableFrom(type)) {
            Object obj = rs.getObject(columnIndex);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Number) {
                if (Double.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).doubleValue();
                } else if (Float.class.isAssignableFrom(type)) {
                    obj = Float.valueOf(((Number)obj).floatValue());
                } else if (Integer.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).intValue();
                } else if (Long.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).longValue();
                } else if (Short.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).shortValue();
                } else if (Byte.class.isAssignableFrom(type)) {
                    obj = ((Number)obj).byteValue();
                }
            }
            return (T)obj;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)rs.getString(columnIndex);
        }
        return (T)rs.getObject(columnIndex);
    }

    public static <T> T execute(Connection con, String id, String sql, List<Object> params, SQLExecuter<T> sqlExecuter, boolean showSql) throws SQLException {
        StringBuilder sb;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            JdbcUtils.setParams(ps, params);
            if (showSql && log.isInfoEnabled()) {
                sb = new StringBuilder();
                sb.append("Execute SQL: ").append(sql).append(COMMA_SPACE).append("parameters: ").append(JSONUtils.toJSONString(params));
                if (id != null) {
                    sb.append(COMMA_SPACE).append("id: ").append(id);
                }
                log.info(sb.toString());
            }
            rs = sqlExecuter.execute(ps);
            sb = sqlExecuter.execute(ps, rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(ps);
        return (T)sb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> int executeBatch(Connection con, boolean showSql, List<T> rows, DMLParser dmlParser) throws SQLException {
        int n;
        Statement ps;
        block11: {
            ps = null;
            try {
                DML dml = dmlParser.parse(((Serializable)rows.get(0)).getClass());
                String sql = dml.getSql();
                List<Field> fields = dml.getFields();
                ps = con.prepareStatement(sql);
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                n = JdbcUtils.getCount(ps.executeBatch());
                if (ps == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> int update(Connection con, boolean showSql, List<T> rows, UpdateSQL updateSQL) throws SQLException {
        int n;
        Statement ps;
        block14: {
            ps = null;
            try {
                String sql = updateSQL.getScript();
                List<Field> fields = updateSQL.getFields();
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                ps = con.prepareStatement(sql);
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                n = JdbcUtils.getCount(ps.executeBatch());
                if (ps == null) break block14;
            }
            catch (SQLException e) {
                try {
                    try {
                        con.rollback();
                        throw e;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw e;
                    catch (Exception e2) {
                        throw new DataAccessException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> int hardUpdate(Connection con, boolean showSql, List<T> rows) throws SQLException {
        int n;
        Statement ps;
        block11: {
            ps = null;
            try {
                DML dml = UpdateDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
                String sql = dml.getSql();
                List<Field> fields = dml.getFields();
                ps = con.prepareStatement(sql);
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                n = JdbcUtils.getCount(ps.executeBatch());
                if (ps == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> int save(Connection con, boolean showSql, List<T> rows, MergeSQL mergeSql) throws SQLException {
        int n;
        Statement ps;
        block14: {
            ps = null;
            try {
                String sql = mergeSql.getScript();
                List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
                if (showSql && log.isInfoEnabled()) {
                    log.info("Execute SQL: ".concat(sql));
                }
                ps = con.prepareStatement(sql);
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                n = JdbcUtils.getCount(ps.executeBatch());
                if (ps == null) break block14;
            }
            catch (SQLException e) {
                try {
                    try {
                        con.rollback();
                        throw e;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw e;
                    catch (Exception e2) {
                        throw new DataAccessException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    public static <T> int hardSave(Connection con, SQLDialect dialect, boolean showSql, List<T> rows) throws SQLException {
        Statement ps = null;
        try {
            MergeSQL mergeSql = dialect.hardSave(rows.get(0).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (showSql && log.isInfoEnabled()) {
                log.info("Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
            }
            int n = JdbcUtils.getCount(ps.executeBatch());
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
        }
    }

    public static final <T> void addBatch(PreparedStatement ps, List<FieldMeta> fieldMetas, T obj) throws SQLException {
        JdbcUtils.setParams(ps, fieldMetas, obj);
        ps.addBatch();
    }

    public static final <T> void addBatch(PreparedStatement ps, T obj, List<Field> fields) throws SQLException {
        JdbcUtils.setParams(ps, obj, fields);
        ps.addBatch();
    }

    private static int getCount(int[] counts) {
        int count = 0;
        if (counts != null) {
            for (int i = 0; i < counts.length; ++i) {
                count += counts[i];
            }
        }
        return count;
    }
}

