/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.tga.javasdk;

import cn.thinkingdata.tga.javasdk.exception.InvalidArgumentException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThinkingDataAnalytics {
    private final Consumer consumer;
    private final Map<String, Object> publicProperties;
    private static final Pattern patternTrack = Pattern.compile("^(#country)|(#province)|(#city)|(#os_version)|(#manufacturer)|(#lib_version)|(#os)|(#device_id)|(#screen_height)|(#device_model)|(#app_version)|(#screen_width)|(#lib)|(#network_type)|(#carrier)|(#browser)|(#browser_version)|([a-z][a-z0-9_]{0,50})$", 2);
    private static final Pattern patternNonTrack = Pattern.compile("^([a-z][a-z0-9_]{0,50})$", 2);

    public ThinkingDataAnalytics(Consumer consumer) {
        this.consumer = consumer;
        this.publicProperties = new ConcurrentHashMap<String, Object>();
        this.clearSuperProperties();
    }

    public void user_del(String account_id, String distinct_id) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("#time", new Date());
        this.add(distinct_id, account_id, "user_del", properties);
    }

    public void user_add(String account_id, String distinct_id, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinct_id, account_id, "user_add", properties);
    }

    public void user_setOnce(String account_id, String distinct_id, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinct_id, account_id, "user_setOnce", properties);
    }

    public void user_set(String account_id, String distinct_id, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinct_id, account_id, "user_set", properties);
    }

    public void track(String account_id, String distinct_id, String event_name, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinct_id, account_id, "track", event_name, properties);
    }

    private void add(String distinct_id, String account_id, String type, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinct_id, account_id, type, null, properties);
    }

    private void add(String distinct_id, String account_id, String type, String event_name, Map<String, Object> properties) throws InvalidArgumentException {
        if (account_id == null && distinct_id == null) {
            throw new InvalidArgumentException("account_id and distinct_id Simultaneously are null ");
        }
        HashMap<String, Object> event = new HashMap<String, Object>();
        if (!properties.containsKey("#time") || !(properties.get("#time") instanceof Date)) {
            throw new InvalidArgumentException("obj.#time must be set and be Date");
        }
        event.put("#time", properties.get("#time"));
        properties.remove("#time");
        if (properties.containsKey("#ip")) {
            event.put("#ip", properties.get("#ip"));
            properties.remove("#ip");
        }
        if (properties != null) {
            this.assertProperties(type, properties);
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (type.equals("track")) {
            eventProperties.putAll(this.publicProperties);
        }
        if (properties != null) {
            eventProperties.putAll(properties);
        }
        if (distinct_id != null) {
            event.put("#distinct_id", distinct_id);
        }
        if (account_id != null) {
            event.put("#account_id", account_id);
        }
        if (event_name != null) {
            event.put("#event_name", event_name);
        }
        event.put("#type", type);
        event.put("properties", eventProperties);
        this.consumer.send(event);
    }

    public void setSuperProperties(Map<String, Object> properties) {
        this.publicProperties.putAll(properties);
    }

    public void clearSuperProperties() {
        this.publicProperties.clear();
        this.publicProperties.put("#lib", "tga_java_sdk");
        this.publicProperties.put("#lib_version", "0.1.1");
    }

    private void assertProperties(String type, Map<String, Object> properties) throws InvalidArgumentException {
        this.assertType("type catgory", type);
        Pattern pattern_key = this.getPatternKey(type);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (pattern_key.matcher(property.getKey()).matches()) {
                if (!(property.getValue() instanceof Number || property.getValue() instanceof Date || property.getValue() instanceof String || property.getValue() instanceof Boolean)) {
                    throw new InvalidArgumentException("The property value should be a basic type: Number, String, Date, Boolean.");
                }
                if (!type.equals("user_add") || property.getValue() instanceof Number) continue;
                throw new InvalidArgumentException("Type user_add only support Number");
            }
            throw new InvalidArgumentException("type " + type + "'key " + property.getKey() + " is invalid");
        }
    }

    private Pattern getPatternKey(String type) {
        if (type.equals("track")) {
            return patternTrack;
        }
        return patternNonTrack;
    }

    private boolean assertType(String description, String type) throws InvalidArgumentException {
        if ("user_set,user_setonce,user_add,user_del,track".contains(type.toLowerCase())) {
            return true;
        }
        throw new InvalidArgumentException(description + " without support : " + type);
    }

    public void flush() {
        this.consumer.flush();
    }

    public void close() {
        this.flush();
    }

    private static class HttpConsumer {
        private final Logger logger = LoggerFactory.getLogger(HttpConsumer.class);
        private final String server_uri;
        private final String appid;

        public HttpConsumer(String server_url, String appid) {
            this(server_url, appid, true);
        }

        private HttpConsumer(String server_url, String appidp, boolean compress_data) {
            this.server_uri = server_url;
            this.appid = appidp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumer(String data) throws Exception {
            CloseableHttpClient httpclient = HttpClients.custom().build();
            HttpPost httppost = null;
            try {
                StringEntity params = new StringEntity(this.encodeRecord(data), "UTF-8");
                httppost = new HttpPost(this.server_uri);
                httppost.setEntity((HttpEntity)params);
                httppost.addHeader("appid", this.appid);
                httppost.addHeader("user-agent", "tga-0.1.0");
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                int code = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                response.close();
                if (code < 200 || code >= 300) {
                    throw new Exception(String.format("Unexcepted response %d from tga:%s", code, result));
                }
            }
            finally {
                if (httpclient != null || httppost != null) {
                    try {
                        httpclient.close();
                        httppost.abort();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private String encodeRecord(String data) {
            ByteArrayOutputStream byteArrayBuffer = new ByteArrayOutputStream();
            try {
                GZIPOutputStream var2 = new GZIPOutputStream(byteArrayBuffer);
                var2.write(data.getBytes(StandardCharsets.UTF_8));
                var2.close();
            }
            catch (IOException var3) {
                this.logger.error("GZIP compress with exception", (Throwable)var3);
                return null;
            }
            return new String(Base64.encodeBase64((byte[])byteArrayBuffer.toByteArray()));
        }
    }

    public static class LoggerConsumer
    implements Consumer {
        private final int batch_size;
        private final String filename_prefix;
        private final ObjectMapper jsonMapper;
        private final StringBuilder message_buffer;
        private static final int BUFFER_LIMITATION = 0x40000000;
        private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private LoggerWriter logger_writer;

        public LoggerConsumer(String filename_prefix) throws FileNotFoundException {
            this(filename_prefix, 8192);
        }

        public LoggerConsumer(String filename_prefix, int batch_size) throws FileNotFoundException {
            this.jsonMapper = new ObjectMapper();
            this.batch_size = batch_size;
            this.message_buffer = new StringBuilder();
            this.filename_prefix = filename_prefix;
            this.logger_writer = new LoggerWriter(filename_prefix);
        }

        @Override
        public synchronized void send(Map<String, Object> message) {
            if (this.message_buffer.length() < 0x40000000) {
                try {
                    this.message_buffer.append(this.jsonMapper.writeValueAsString(message));
                    this.message_buffer.append("\n");
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to become json", e);
                }
            } else {
                throw new RuntimeException("Logging buffer exceeded the allowed limitation.");
            }
            if (this.message_buffer.length() >= this.batch_size) {
                this.flush();
            }
        }

        @Override
        public synchronized void flush() {
            if (this.message_buffer.length() == 0) {
                return;
            }
            if (!this.logger_writer.isValid(this.filename_prefix + File.separator + "log." + this.simpleDateFormat.format(new Date()))) {
                this.logger_writer = null;
            }
            if (this.logger_writer == null) {
                try {
                    this.logger_writer = new LoggerWriter(this.filename_prefix);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.logger_writer.write(this.message_buffer)) {
                this.message_buffer.setLength(0);
            }
        }

        @Override
        public void close() {
            this.flush();
            this.logger_writer = null;
        }

        static class LoggerWriter {
            private String filename_last;
            private FileOutputStream outputStream;
            private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

            public LoggerWriter(String filename) throws FileNotFoundException {
                File parent_directory;
                String file_complete = new File(filename) + File.separator + "log." + this.simpleDateFormat.format(new Date());
                if (this.filename_last == null || !this.filename_last.equals(file_complete)) {
                    this.filename_last = file_complete;
                }
                if (!(parent_directory = new File(file_complete).getParentFile()).exists()) {
                    throw new FileNotFoundException(parent_directory.toString());
                }
                this.outputStream = new FileOutputStream(new File(file_complete), true);
            }

            public void close() {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close OutPutStream", e);
                }
            }

            public boolean isValid(String filename) {
                return this.filename_last.equals(filename);
            }

            public boolean write(StringBuilder buffer) {
                FileLock lock = null;
                try {
                    FileChannel channel = this.outputStream.getChannel();
                    lock = channel.lock(0L, Long.MAX_VALUE, false);
                    this.outputStream.write(buffer.toString().getBytes("UTF-8"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (lock != null) {
                        try {
                            lock.release();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return true;
            }
        }
    }

    public static class BatchConsumer
    implements Consumer {
        private final Logger logger = LoggerFactory.getLogger(BatchConsumer.class);
        private final ArrayList<Map<String, Object>> message_channel = new ArrayList();
        private final HttpConsumer httpConsumer;
        private final ObjectMapper jsonMapper;
        private final int batch_size;
        private static final int MAX_FLUSH_SIZE = 500;

        public BatchConsumer(String server_uri, String appid) {
            this(server_uri, appid, 500);
        }

        public BatchConsumer(String server_uri, String appid, int batch_size) {
            this.httpConsumer = new HttpConsumer(server_uri, appid);
            this.jsonMapper = new ObjectMapper();
            this.batch_size = Math.min(batch_size, 500);
            this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.jsonMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            this.jsonMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Map<String, Object> message) {
            ArrayList<Map<String, Object>> arrayList = this.message_channel;
            synchronized (arrayList) {
                this.message_channel.add(message);
                if (this.message_channel.size() >= this.batch_size) {
                    this.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            ArrayList<Map<String, Object>> arrayList = this.message_channel;
            synchronized (arrayList) {
                String data = null;
                try {
                    data = this.jsonMapper.writeValueAsString(this.message_channel);
                }
                catch (JsonProcessingException e) {
                    this.message_channel.clear();
                    this.logger.error(e.getMessage());
                    throw new RuntimeException("Failed to become json ", e);
                }
                try {
                    this.httpConsumer.consumer(data);
                    this.message_channel.clear();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    throw new RuntimeException("Failed to transform with BatchConsumer", e);
                }
            }
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    private static interface Consumer {
        public void send(Map<String, Object> var1);

        public void flush();

        public void close();
    }
}

