package cn.thinkingdata.tga.javasdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

/**
 * Created by quanjie on 2018/4/16.
 */
public class ProduceKafka implements Consumer{
    private Properties props = new Properties();
    private Producer<String,String> producer = null;
    private String topic = null;
    private final ObjectMapper jsonMapper;

    public ProduceKafka(String Server,String topic){
        props.put("bootstrap.servers", Server);
        props.put("acks", "all");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.topic = topic;
        jsonMapper = new ObjectMapper();
    }
    public ProduceKafka(String Server){
        this(Server,"tga_monitor");
    }
    @Override
    public void send(Map<String, Object> message) {
        this.init();
        try {
            String value = jsonMapper.writeValueAsString(message);
            System.out.println(value);
            producer.send(new ProducerRecord<String, String>(this.topic, value));
        } catch (Exception e) {
            throw new RuntimeException("Failed to become json",e);
        }

    }

    @Override
    public void flush() {
        producer.flush();
    }

    @Override
    public void close() {
        this.flush();
        producer.close();
    }

    public void setProps(String key,Object value){
        this.props.put(key,value);
    }
    public void setTopic(String topic){
        this.topic = topic ;
    }
    private void init(){
        if(producer == null){
            producer = new KafkaProducer<>(props);
        }
    }
}
