/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.web.advice;

import cn.meteor.common.enums.ResultType;
import cn.meteor.common.exception.ServiceException;
import cn.meteor.common.interfaces.IResultType;
import cn.meteor.common.model.R;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
@ConditionalOnMissingBean(value={WebMvcAutoConfiguration.class})
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class, ConstraintViolationException.class})
    public R<Object> failure(Exception e) {
        BindingResult result = null;
        if (e instanceof MethodArgumentNotValidException) {
            result = ((MethodArgumentNotValidException)e).getBindingResult();
        } else if (e instanceof BindException) {
            result = ((BindException)e).getBindingResult();
        } else if (e instanceof ConstraintViolationException) {
            Optional first = ((ConstraintViolationException)e).getConstraintViolations().stream().findFirst();
            return R.failure((String)(first.isPresent() ? ((ConstraintViolation)first.get()).getMessage() : e.getMessage()));
        }
        if (result == null) {
            return R.failure((Logger)log, (IResultType)ResultType.SERVER_ERROR, (Exception)e);
        }
        return result.hasErrors() ? R.failure((String)((ObjectError)result.getAllErrors().get(0)).getDefaultMessage()) : R.success();
    }

    @ExceptionHandler(value={Exception.class, Throwable.class, Error.class, IOException.class, RuntimeException.class})
    public R<Object> failure(Exception e, HttpServletResponse response) {
        response.setStatus(HttpStatus.OK.value());
        R result = e instanceof ServiceException ? R.failure((ServiceException)((ServiceException)e)) : (e instanceof HttpRequestMethodNotSupportedException ? R.failure((String)(((HttpRequestMethodNotSupportedException)e).getMethod() + "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u88ab\u652f\u6301")) : (e instanceof MissingServletRequestParameterException ? R.failure((String)e.getMessage()) : (e instanceof HttpMessageNotReadableException ? R.failure((IResultType)ResultType.REQUEST_MISSING_BODY_ERROR) : (e instanceof HttpMediaTypeNotSupportedException ? R.failure((IResultType)ResultType.CONTENT_TYPE_ERROR) : (e instanceof MethodArgumentTypeMismatchException ? R.failure((IResultType)ResultType.ACCEPT_ERROR) : (e instanceof HttpMediaTypeNotAcceptableException ? R.failure((IResultType)ResultType.NOT_ACCEPT_ERROR) : (e instanceof MethodArgumentNotValidException ? R.failure((IResultType)ResultType.PARAMETER_ERROR) : (e instanceof HttpMessageConversionException ? R.failure((Logger)log, (IResultType)ResultType.MESSAGE_CONVERT, (Exception)e) : (e instanceof SocketTimeoutException ? R.failure((Logger)log, (IResultType)ResultType.SOCKET_TIMEOUT, (Exception)e) : (e instanceof IllegalArgumentException ? R.failure((String)e.getMessage()) : R.failure((Logger)log, (IResultType)ResultType.SERVER_ERROR, (Exception)e)))))))))));
        return result;
    }
}

