/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.web.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateUtil {
    public static final RestTemplate REST = new RestTemplate();

    public static String get(String url) {
        return RestTemplateUtil.get(url, null, String.class);
    }

    public static String get(String url, Map<String, Object> reqMap) {
        return RestTemplateUtil.get(url, null, reqMap, String.class);
    }

    public static <T> T get(String url, Class<T> resp) {
        return RestTemplateUtil.get(url, null, resp);
    }

    public static <T> T get(String url, Map<String, String> headerMap, Class<T> resp) {
        return RestTemplateUtil.get(url, headerMap, null, resp);
    }

    public static <T> T get(String url, Map<String, String> headerMap, Map<String, Object> reqMap, Class<T> resp) {
        String reallyUrl = url;
        if (reqMap != null) {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            for (Map.Entry<String, Object> entry : reqMap.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            reallyUrl = builder.build().toString();
        }
        return RestTemplateUtil.exchange(reallyUrl, HttpMethod.POST, headerMap, null, resp);
    }

    public static String post(String url, Map<String, Object> reqMap) {
        return RestTemplateUtil.post(url, reqMap, String.class);
    }

    public static String post(String url, Map<String, String> headerMap, Map<String, Object> reqMap) {
        return RestTemplateUtil.post(url, headerMap, reqMap, String.class);
    }

    public static <T> T post(String url, Map<String, Object> reqMap, Class<T> resp) {
        return RestTemplateUtil.post(url, null, reqMap, resp);
    }

    public static <T> T post(String url, Map<String, String> headerMap, Map<String, Object> reqMap, Class<T> resp) {
        return RestTemplateUtil.exchange(url, HttpMethod.POST, headerMap, reqMap, resp);
    }

    public static <T> T exchange(String url, HttpMethod method, Map<String, String> headerMap, Map<String, Object> reqMap, Class<T> resp) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (headerMap != null) {
            for (Map.Entry<String, String> stringStringEntry : headerMap.entrySet()) {
                httpHeaders.add(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        if (reqMap == null) {
            reqMap = new HashMap<String, Object>();
        }
        HttpEntity httpEntity = new HttpEntity(reqMap, (MultiValueMap)httpHeaders);
        ResponseEntity result = REST.exchange(url, method, httpEntity, resp, new Object[0]);
        return (T)result.getBody();
    }
}

