/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.pathx.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;

public class AddUGATaskParam
extends BaseRequestParam {
    @UcloudParam(value="UGAId")
    @NotEmpty(message="uGAId can not be empty")
    private @NotEmpty(message="uGAId can not be empty") String uGAId;
    private List<Integer> tcpPorts;
    private List<Integer> udpPorts;

    public AddUGATaskParam(String projectId, String uGAId) {
        super("AddUGATask");
        this.projectId = projectId;
        this.uGAId = uGAId;
    }

    @UcloudParam(value="TCP")
    public List<Param> checkTCPPorts() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.tcpPorts != null) {
            int size = this.tcpPorts.size();
            for (int i = 0; i < size; ++i) {
                Integer port = this.tcpPorts.get(i);
                if (port == null) {
                    throw new ValidationException(String.format("tcpPorts[%d] can not be null", i));
                }
                params.add(new Param(String.format("TCP.%d", i), (Object)port));
            }
        }
        return params;
    }

    @UcloudParam(value="UDP")
    public List<Param> checkUDPPorts() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.udpPorts != null) {
            int size = this.udpPorts.size();
            for (int i = 0; i < size; ++i) {
                Integer port = this.udpPorts.get(i);
                if (port == null) {
                    throw new ValidationException(String.format("udpPorts[%d] can not be null", i));
                }
                params.add(new Param(String.format("UDP.%d", i), (Object)port));
            }
        }
        return params;
    }

    public List<Integer> getTcpPorts() {
        return this.tcpPorts;
    }

    public void setTcpPorts(List<Integer> tcpPorts) {
        this.tcpPorts = tcpPorts;
    }

    public List<Integer> getUdpPorts() {
        return this.udpPorts;
    }

    public void setUdpPorts(List<Integer> udpPorts) {
        this.udpPorts = udpPorts;
    }

    public String getuGAId() {
        return this.uGAId;
    }

    public void setuGAId(String uGAId) {
        this.uGAId = uGAId;
    }
}

