/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.pathx.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;

public class CreateUGAInstanceParam
extends BaseRequestParam {
    @UcloudParam(value="Name")
    @NotEmpty(message="name can not be empty")
    private @NotEmpty(message="name can not be empty") String name;
    @UcloudParam(value="IPList")
    private String iPList;
    @UcloudParam(value="Domain")
    private String domain;
    @UcloudParam(value="ChargeType")
    private String chargeType;
    @UcloudParam(value="Quantity")
    private Integer quantity;
    @UcloudParam(value="IsHighNet")
    private Boolean isHighNet;
    @NotEmpty(message="location can not be empty")
    @UcloudParam(value="Location")
    private @NotEmpty(message="location can not be empty") String location;
    private List<Integer> tcpPorts;
    private List<Integer> udpPorts;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getHighNet() {
        return this.isHighNet;
    }

    public void setHighNet(Boolean highNet) {
        this.isHighNet = highNet;
    }

    public CreateUGAInstanceParam(String projectId, String name, String location) {
        super("CreateUGAInstance");
        this.projectId = projectId;
        this.name = name;
        this.location = location;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    @UcloudParam(value="TCP")
    public List<Param> checkTCPPorts() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.tcpPorts != null) {
            int size = this.tcpPorts.size();
            for (int i = 0; i < size; ++i) {
                Integer port = this.tcpPorts.get(i);
                if (port == null) {
                    throw new ValidationException(String.format("tcpPorts[%d] can not be null", i));
                }
                params.add(new Param(String.format("TCP.%d", i), (Object)port));
            }
        }
        return params;
    }

    @UcloudParam(value="UDP")
    public List<Param> checkUDPPorts() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.udpPorts != null) {
            int size = this.udpPorts.size();
            for (int i = 0; i < size; ++i) {
                Integer port = this.udpPorts.get(i);
                if (port == null) {
                    throw new ValidationException(String.format("udpPorts[%d] can not be null", i));
                }
                params.add(new Param(String.format("UDP.%d", i), (Object)port));
            }
        }
        return params;
    }

    public List<Integer> getTcpPorts() {
        return this.tcpPorts;
    }

    public void setTcpPorts(List<Integer> tcpPorts) {
        this.tcpPorts = tcpPorts;
    }

    public List<Integer> getUdpPorts() {
        return this.udpPorts;
    }

    public void setUdpPorts(List<Integer> udpPorts) {
        this.udpPorts = udpPorts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getiPList() {
        return this.iPList;
    }

    public void setiPList(String iPList) {
        this.iPList = iPList;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

