/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.pathx.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.ValidationException;

public class ModifyUPathTemplateParam
extends BaseRequestParam {
    @UcloudParam(value="UPathID")
    private String uPathID;
    private List<Template> templates;

    public ModifyUPathTemplateParam(String projectId, String uPathID) {
        super("ModifyUPathTemplate");
        this.projectId = projectId;
        this.uPathID = uPathID;
    }

    @UcloudParam(value="Template")
    public List<Param> checkTemplates() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.templates != null) {
            int size = this.templates.size();
            for (int i = 0; i < size; ++i) {
                Template template = this.templates.get(i);
                if (template == null) {
                    throw new ValidationException(String.format("templates[%d] can not be null", i));
                }
                if (template.getMetricName() == null || template.getMetricName().length() <= 0) {
                    throw new ValidationException(String.format("templates[%d].metricName can not be empty", i));
                }
                params.add(new Param(String.format("MetricName.%d", i), (Object)template.getMetricName()));
                if (template.getAlarmFrequency() == null) {
                    throw new ValidationException(String.format("templates[%d].alarmFrequency can not be null", i));
                }
                params.add(new Param(String.format("AlarmFrequency.%d", i), (Object)template.getMetricName()));
                if (template.getAlarmStrategy() == null || template.getAlarmStrategy().length() <= 0) {
                    throw new ValidationException(String.format("templates[%d].alarmStrategy can not be empty", i));
                }
                params.add(new Param(String.format("AlarmStrategy.%d", i), (Object)template.getMetricName()));
                if (template.getCompare() == null || template.getCompare().length() <= 0) {
                    throw new ValidationException(String.format("templates[%d].compare can not be empty", i));
                }
                params.add(new Param(String.format("Compare.%d", i), (Object)template.getMetricName()));
                if (template.getContactGroupId() == null) {
                    throw new ValidationException(String.format("templates[%d].contactGroupId can not be null", i));
                }
                params.add(new Param(String.format("ContactGroupId.%d", i), (Object)template.getMetricName()));
                if (template.getThreshold() == null) {
                    throw new ValidationException(String.format("templates[%d].threshold can not be null", i));
                }
                params.add(new Param(String.format("Threshold.%d", i), (Object)template.getMetricName()));
                if (template.getTriggerCount() == null) {
                    throw new ValidationException(String.format("templates[%d].triggerCount can not be null", i));
                }
                params.add(new Param(String.format("TriggerCount.%d", i), (Object)template.getMetricName()));
            }
        }
        return params;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }

    public String getuPathID() {
        return this.uPathID;
    }

    public void setuPathID(String uPathID) {
        this.uPathID = uPathID;
    }

    public static class Template {
        private String metricName;
        private Integer threshold;
        private Integer alarmFrequency;
        private Integer contactGroupId;
        private String compare;
        private String alarmStrategy;
        private Integer triggerCount;

        public Template(String metricName, Integer threshold, Integer alarmFrequency, Integer contactGroupId, String compare, String alarmStrategy, Integer triggerCount) {
            this.metricName = metricName;
            this.threshold = threshold;
            this.alarmFrequency = alarmFrequency;
            this.contactGroupId = contactGroupId;
            this.compare = compare;
            this.alarmStrategy = alarmStrategy;
            this.triggerCount = triggerCount;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public Integer getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Integer threshold) {
            this.threshold = threshold;
        }

        public Integer getAlarmFrequency() {
            return this.alarmFrequency;
        }

        public void setAlarmFrequency(Integer alarmFrequency) {
            this.alarmFrequency = alarmFrequency;
        }

        public Integer getContactGroupId() {
            return this.contactGroupId;
        }

        public void setContactGroupId(Integer contactGroupId) {
            this.contactGroupId = contactGroupId;
        }

        public String getCompare() {
            return this.compare;
        }

        public void setCompare(String compare) {
            this.compare = compare;
        }

        public String getAlarmStrategy() {
            return this.alarmStrategy;
        }

        public void setAlarmStrategy(String alarmStrategy) {
            this.alarmStrategy = alarmStrategy;
        }

        public Integer getTriggerCount() {
            return this.triggerCount;
        }

        public void setTriggerCount(Integer triggerCount) {
            this.triggerCount = triggerCount;
        }
    }
}

