/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.uhost.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.codec.binary.Base64;

public class CreateUHostInstanceParam
extends BaseRequestParam {
    @NotEmpty(message="region can not be empty")
    @UcloudParam(value="Region")
    private @NotEmpty(message="region can not be empty") String region;
    @UcloudParam(value="Zone")
    @NotEmpty(message="zone can not be empty")
    private @NotEmpty(message="zone can not be empty") String zone;
    @NotEmpty(message="imageId can not be empty")
    @UcloudParam(value="ImageId")
    private @NotEmpty(message="imageId can not be empty") String imageId;
    private String password;
    @UcloudParam(value="Name")
    private String name;
    @UcloudParam(value="Tag")
    private String tag;
    @UcloudParam(value="ChargeType")
    private String chargeType;
    @UcloudParam(value="Quantity")
    private Integer quantity;
    @UcloudParam(value="UHostType")
    private String uhostType;
    @UcloudParam(value="CPU")
    private Integer cpu;
    private Integer memory;
    private List<UhostDisk> disks;
    @UcloudParam(value="GPU")
    private Integer gpu;
    @UcloudParam(value="LoginMode")
    private String loginMode;
    private String keyPair;
    @UcloudParam(value="StorageType")
    private String storageType;
    @UcloudParam(value="BootDiskSpace")
    private Integer bootDiskSpace;
    @UcloudParam(value="DiskSpace")
    private Integer diskSpace;
    @UcloudParam(value="NetCapAbility")
    private String netcapAbitity;
    @UcloudParam(value="TimemachineFeature")
    private String timeMachineFeature;
    @UcloudParam(value="HotplugFeature")
    private Boolean hotPlugFeature;
    @UcloudParam(value="DiskPassword")
    private String diskPassword;
    @UcloudParam(value="NetworkId")
    private String networkId;
    @UcloudParam(value="VPCId")
    private String VpcId;
    @UcloudParam(value="SubnetId")
    private String subnetId;
    private List<String> privateIp;
    @UcloudParam(value="PrivateMac")
    private String privateMac;
    @UcloudParam(value="SecurityGroupId")
    private String securityGroupId;
    @UcloudParam(value="UserDataScript")
    private String userDataScript;
    @UcloudParam(value="InstallAgent")
    private String installAgent;
    @UcloudParam(value="CouponId")
    private String couponId;
    @UcloudParam(value="ResourceType")
    private String resourceType;

    public CreateUHostInstanceParam(@NotEmpty(message="region can not be empty") @NotEmpty(message="region can not be empty") String region, @NotEmpty(message="zone can not be empty") @NotEmpty(message="zone can not be empty") String zone, @NotEmpty(message="imageId can not be empty") @NotEmpty(message="imageId can not be empty") String imageId) {
        super("CreateUHostInstance");
        this.region = region;
        this.zone = zone;
        this.imageId = imageId;
    }

    @UcloudParam(value="Password")
    public List<Param> checkPassword() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if (!"KeyPair".equals(this.getLoginMode())) {
            this.setLoginMode("Password");
        }
        if ("Password".equals(this.getLoginMode())) {
            if (this.getPassword() != null && !"".equals(this.getPassword())) {
                try {
                    list.add(new Param("Password", (Object)new String(Base64.encodeBase64((byte[])this.password.getBytes("utf-8")))));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                throw new ValidatorException("password can not be empty with loginModel equal Password");
            }
        }
        return list;
    }

    @UcloudParam(value="UhostDisk")
    public List<Param> checkUhostDisk() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.getDisks() != null && this.getDisks().size() > 0) {
            List<UhostDisk> uhostDisks = this.getDisks();
            int len = uhostDisks.size();
            for (int i = 0; i < len; ++i) {
                UhostDisk disk = uhostDisks.get(i);
                if (disk == null) {
                    throw new ValidatorException("uhost.disk[" + i + "] can not be null");
                }
                if (disk.getSize() == null || disk.getSize() <= 0) {
                    throw new ValidatorException("uhost.disk[" + i + "].size can not be null or size <= 0");
                }
                if (disk.getBoot() == null) {
                    throw new ValidatorException("uhost.disk[" + i + "].isBoot can not be null");
                }
                if (disk.getType() == null || disk.getType().length() <= 0) {
                    throw new ValidatorException("uhost.disk[" + i + "].type can not be null");
                }
                list.add(new Param("Disks." + i + ".Size", (Object)disk.getSize()));
                list.add(new Param("Disks." + i + ".Type", (Object)disk.getType()));
                list.add(new Param("Disks." + i + ".IsBoot", (Object)disk.getBoot()));
                if (disk.backupType == null || disk.getBackupType().length() <= 0) continue;
                list.add(new Param("Disks." + i + ".BackupType", (Object)disk.getBackupType()));
            }
        }
        return list;
    }

    @UcloudParam(value="KeyPair")
    public List<Param> checkKeyPair() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if ("KeyPair".equals(this.getLoginMode())) {
            if (this.getKeyPair() != null && this.getKeyPair().length() > 0) {
                list.add(new Param("KeyPair", (Object)this.getKeyPair()));
            } else {
                throw new ValidationException("keyPair can not be empty with loginModel equals KeyPair");
            }
        }
        return list;
    }

    @UcloudParam(value="PrivateIp")
    public List<Param> checkPrivateIp() {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.getPrivateIp() != null) {
            int len = this.getPrivateIp().size();
            for (int i = 0; i < len; ++i) {
                String ip = this.getPrivateIp().get(i);
                if (ip == null || ip.length() <= 0) {
                    throw new ValidationException("privateIp[" + i + "] can not be null or length <= 0");
                }
                list.add(new Param("PrivateIp." + i, (Object)ip));
            }
        }
        return list;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public List<UhostDisk> getDisks() {
        return this.disks;
    }

    public void setDisks(List<UhostDisk> disks) {
        this.disks = disks;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getUhostType() {
        return this.uhostType;
    }

    public void setUhostType(String uhostType) {
        this.uhostType = uhostType;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public Integer getGpu() {
        return this.gpu;
    }

    public void setGpu(Integer gpu) {
        this.gpu = gpu;
    }

    public String getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(String loginMode) {
        this.loginMode = loginMode;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public Integer getBootDiskSpace() {
        return this.bootDiskSpace;
    }

    public void setBootDiskSpace(Integer bootDiskSpace) {
        this.bootDiskSpace = bootDiskSpace;
    }

    public Integer getDiskSpace() {
        return this.diskSpace;
    }

    public void setDiskSpace(Integer diskSpace) {
        this.diskSpace = diskSpace;
    }

    public String getNetcapAbitity() {
        return this.netcapAbitity;
    }

    public void setNetcapAbitity(String netcapAbitity) {
        this.netcapAbitity = netcapAbitity;
    }

    public String getTimeMachineFeature() {
        return this.timeMachineFeature;
    }

    public void setTimeMachineFeature(String timeMachineFeature) {
        this.timeMachineFeature = timeMachineFeature;
    }

    public Boolean getHotPlugFeature() {
        return this.hotPlugFeature;
    }

    public void setHotPlugFeature(Boolean hotPlugFeature) {
        this.hotPlugFeature = hotPlugFeature;
    }

    public String getDiskPassword() {
        return this.diskPassword;
    }

    public void setDiskPassword(String diskPassword) {
        this.diskPassword = diskPassword;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    public String getVpcId() {
        return this.VpcId;
    }

    public void setVpcId(String vpcId) {
        this.VpcId = vpcId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public List<String> getPrivateIp() {
        return this.privateIp;
    }

    public void setPrivateIp(List<String> privateIp) {
        this.privateIp = privateIp;
    }

    public String getPrivateMac() {
        return this.privateMac;
    }

    public void setPrivateMac(String privateMac) {
        this.privateMac = privateMac;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public void setSecurityGroupId(String securityGroupId) {
        this.securityGroupId = securityGroupId;
    }

    public String getUserDataScript() {
        return this.userDataScript;
    }

    public void setUserDataScript(String userDataScript) {
        this.userDataScript = userDataScript;
    }

    public String getInstallAgent() {
        return this.installAgent;
    }

    public void setInstallAgent(String installAgent) {
        this.installAgent = installAgent;
    }

    public String getCouponId() {
        return this.couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public static class UhostDisk {
        private Integer size;
        private String type;
        private Boolean isBoot;
        private String backupType;

        public UhostDisk(@NotEmpty(message="uhost.disk.size can not be empty") @NotEmpty(message="uhost.disk.size can not be empty") Integer size, @NotEmpty(message="uhost.disk.type can not be empty") @NotEmpty(message="uhost.disk.type can not be empty") String type, @NotEmpty(message="uhost.disk.isboot can not be null") @NotEmpty(message="uhost.disk.isboot can not be null") Boolean isBoot) {
            this.size = size;
            this.type = type;
            this.isBoot = isBoot;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Boolean getBoot() {
            return this.isBoot;
        }

        public void setBoot(Boolean boot) {
            this.isBoot = boot;
        }

        public String getBackupType() {
            return this.backupType;
        }

        public void setBackupType(String backupType) {
            this.backupType = backupType;
        }
    }
}

