/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.uhost.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;

public class GetUHostInstancePriceParam
extends BaseRequestParam {
    @UcloudParam(value="Region")
    @NotEmpty(message="region can not be empty")
    private @NotEmpty(message="region can not be empty") String region;
    @UcloudParam(value="Zone")
    private String zone;
    @UcloudParam(value="ImageId")
    @NotEmpty(message="imageId can not be empty")
    private @NotEmpty(message="imageId can not be empty") String imageId;
    @UcloudParam(value="CPU")
    @NotEmpty(message="cpu can not be empty")
    private @NotEmpty(message="cpu can not be empty") Integer cpu;
    @UcloudParam(value="Memory")
    @NotEmpty(message="memory can not be empty")
    private @NotEmpty(message="memory can not be empty") Integer memory;
    @UcloudParam(value="Count")
    @NotEmpty(message="count can not be empty")
    private @NotEmpty(message="count can not be empty") Integer count;
    private List<UhostDisk> disks;
    @UcloudParam(value="GPU")
    private Integer gpu;
    @UcloudParam(value="ChargeType")
    private String chargeType;
    @UcloudParam(value="StorageType")
    private String storageType;
    @UcloudParam(value="DiskSpace")
    private Integer diskSpace;
    @UcloudParam(value="NetCapability")
    private String netCapAbility;
    @UcloudParam(value="TimemachineFeature")
    private String timeMachineFeature;
    @UcloudParam(value="UHostType")
    private String uhostType;
    @UcloudParam(value="LifeCycle")
    private Integer lifeCycle;
    @UcloudParam(value="Quantity")
    private Integer quantity;

    public GetUHostInstancePriceParam(@NotEmpty(message="region can not be empty") @NotEmpty(message="region can not be empty") String region, @NotEmpty(message="imageId can not be empty") @NotEmpty(message="imageId can not be empty") String imageId, @NotEmpty(message="cpu can not be empty") @NotEmpty(message="cpu can not be empty") Integer cpu, @NotEmpty(message="memory can not be empty") @NotEmpty(message="memory can not be empty") Integer memory, @NotEmpty(message="count can not be empty") @NotEmpty(message="count can not be empty") Integer count) {
        super("GetUHostInstancePrice");
        this.region = region;
        this.imageId = imageId;
        this.cpu = cpu;
        this.memory = memory;
        this.count = count;
    }

    @UcloudParam(value="UhostDisk")
    public List<Param> checkUhostDisk() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.getDisks() != null && this.getDisks().size() > 0) {
            List<UhostDisk> uhostDisks = this.getDisks();
            int len = uhostDisks.size();
            for (int i = 0; i < len; ++i) {
                UhostDisk disk = uhostDisks.get(i);
                if (disk == null) {
                    throw new ValidatorException("uhost.disk[" + i + "] can not be null");
                }
                if (disk.getSize() == null || disk.getSize() <= 0) {
                    throw new ValidatorException("uhost.disk[" + i + "].size can not be null or size <= 0");
                }
                if (disk.getBoot() == null) {
                    throw new ValidatorException("uhost.disk[" + i + "].isBoot can not be null");
                }
                if (disk.getType() == null || disk.getType().length() <= 0) {
                    throw new ValidatorException("uhost.disk[" + i + "].type can not be null");
                }
                list.add(new Param("Disks." + i + ".Size", (Object)disk.getSize()));
                list.add(new Param("Disks." + i + ".Type", (Object)disk.getType()));
                list.add(new Param("Disks." + i + ".IsBoot", (Object)disk.getBoot()));
                if (disk.backupType == null || disk.getBackupType().length() <= 0) continue;
                list.add(new Param("Disks." + i + ".BackupType", (Object)disk.getBackupType()));
            }
        }
        return list;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public List<UhostDisk> getDisks() {
        return this.disks;
    }

    public void setDisks(List<UhostDisk> disks) {
        this.disks = disks;
    }

    public Integer getGpu() {
        return this.gpu;
    }

    public void setGpu(Integer gpu) {
        this.gpu = gpu;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public Integer getDiskSpace() {
        return this.diskSpace;
    }

    public void setDiskSpace(Integer diskSpace) {
        this.diskSpace = diskSpace;
    }

    public String getNetCapAbility() {
        return this.netCapAbility;
    }

    public void setNetCapAbility(String netCapAbility) {
        this.netCapAbility = netCapAbility;
    }

    public String getTimeMachineFeature() {
        return this.timeMachineFeature;
    }

    public void setTimeMachineFeature(String timeMachineFeature) {
        this.timeMachineFeature = timeMachineFeature;
    }

    public String getUhostType() {
        return this.uhostType;
    }

    public void setUhostType(String uhostType) {
        this.uhostType = uhostType;
    }

    public Integer getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(Integer lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public static class UhostDisk {
        private Integer size;
        private String type;
        private Boolean isBoot;
        private String backupType;

        public UhostDisk(@NotEmpty(message="uhost.disk.size can not be empty") @NotEmpty(message="uhost.disk.size can not be empty") Integer size, @NotEmpty(message="uhost.disk.type can not be empty") @NotEmpty(message="uhost.disk.type can not be empty") String type, @NotEmpty(message="uhost.disk.isboot can not be null") @NotEmpty(message="uhost.disk.isboot can not be null") Boolean isBoot) {
            this.size = size;
            this.type = type;
            this.isBoot = isBoot;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Boolean getBoot() {
            return this.isBoot;
        }

        public void setBoot(Boolean boot) {
            this.isBoot = boot;
        }

        public String getBackupType() {
            return this.backupType;
        }

        public void setBackupType(String backupType) {
            this.backupType = backupType;
        }
    }
}

