/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.uhost.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.codec.binary.Base64;

public class ReinstallUHostInstanceParam
extends BaseRequestParam {
    @UcloudParam(value="Region")
    @NotEmpty(message="region can not be empty")
    private @NotEmpty(message="region can not be empty") String region;
    @UcloudParam(value="Zone")
    private String zone;
    @NotEmpty(message="uhostId can not be null")
    @UcloudParam(value="UHostId")
    private @NotEmpty(message="uhostId can not be null") String uhostId;
    private String password;
    @UcloudParam(value="ImageId")
    private String imageId;
    @UcloudParam(value="ReserveDisk")
    private String reserveDisk;
    @UcloudParam(value="ResourceType")
    private Integer resourceType;
    private List<String> dnsServers;

    @UcloudParam(value="Password")
    private List<Param> checkPassord() throws Exception {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.password == null) {
            throw new ValidationException("password can not be empty");
        }
        list.add(new Param("Password", (Object)new String(Base64.encodeBase64((byte[])this.password.getBytes("utf-8")))));
        return list;
    }

    @UcloudParam(value="DNSServers")
    public List<Param> checkDnsServers() throws Exception {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.dnsServers != null) {
            int len = this.dnsServers.size();
            for (int i = 0; i < len; ++i) {
                String dns = this.dnsServers.get(i);
                if (dns == null || dns.length() <= 0) continue;
                list.add(new Param("DNSServers." + i, (Object)dns));
            }
        }
        return list;
    }

    public ReinstallUHostInstanceParam(@NotEmpty(message="region can not be empty") @NotEmpty(message="region can not be empty") String region, @NotEmpty(message="uhostId can not be null") @NotEmpty(message="uhostId can not be null") String uhostId) {
        super("ReinstallUHostInstance");
        this.region = region;
        this.uhostId = uhostId;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getUhostId() {
        return this.uhostId;
    }

    public void setUhostId(String uhostId) {
        this.uhostId = uhostId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getReserveDisk() {
        return this.reserveDisk;
    }

    public void setReserveDisk(String reserveDisk) {
        this.reserveDisk = reserveDisk;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public List<String> getDnsServers() {
        return this.dnsServers;
    }

    public void setDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
    }
}

