/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.tool.StringUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class Self {
    Self() {
    }

    static JsonObject deNull(JsonObject entity, boolean immutable) {
        JsonObject result = immutable ? entity.copy() : entity;
        Set keys = entity.fieldNames().stream().filter(field -> Objects.isNull(entity.getValue(field))).collect(Collectors.toSet());
        Observable.fromIterable(keys).subscribe(arg_0 -> ((JsonObject)result).remove(arg_0));
        return result;
    }

    static JsonObject remove(JsonObject entity, boolean immutable, String ... keys) {
        JsonObject result = immutable ? entity.copy() : entity;
        Observable.fromArray((Object[])keys).filter(StringUtil::notNil).map(arg_0 -> ((JsonObject)result).remove(arg_0)).subscribe();
        return result;
    }

    static JsonArray remove(JsonArray array, boolean immutable, String ... keys) {
        JsonArray result = immutable ? array.copy() : array;
        JsonArray finals = new JsonArray();
        Fn.itJArray(result, JsonObject.class, (item, index) -> {
            JsonObject removed = Self.remove(item, false, keys);
            finals.add(removed);
        });
        return finals;
    }

    static JsonObject copy(JsonObject entity, String from, String to, boolean immutable) {
        JsonObject result;
        JsonObject jsonObject = result = immutable ? entity.copy() : entity;
        if (StringUtil.notNil(to) && entity.containsKey(from)) {
            result.put(to, entity.getValue(from));
        }
        return result;
    }

    static JsonArray copy(JsonArray array, String from, String to, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).subscribe(item -> Self.copy(item, from, to, false));
        return result;
    }

    static JsonArray filter(JsonArray array, Predicate<JsonObject> testFun, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        JsonArray filtered = new JsonArray();
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).filter(testFun::test).subscribe(arg_0 -> ((JsonArray)filtered).add(arg_0));
        result.clear().addAll(filtered);
        return result;
    }

    static JsonObject defaultValue(JsonObject json, JsonObject filled, boolean immutable) {
        JsonObject result = immutable ? json.copy() : json;
        for (String field : filled.fieldNames()) {
            Self.defaultValue(result, field, filled.getValue(field), false);
        }
        return result;
    }

    static JsonArray defaultValue(JsonArray jsonArray, JsonObject filled, boolean immutable) {
        JsonArray result = immutable ? jsonArray.copy() : jsonArray;
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).subscribe(item -> Self.defaultValue(item, filled, false));
        return result;
    }

    static JsonArray defaultValue(JsonArray jsonArray, String field, Object value, boolean immutable) {
        JsonArray result = immutable ? jsonArray.copy() : jsonArray;
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).subscribe(item -> Self.defaultValue(item, field, value, false));
        return result;
    }

    static JsonObject defaultValue(JsonObject json, String field, Object value, boolean immutable) {
        JsonObject result;
        JsonObject jsonObject = result = immutable ? json.copy() : json;
        if (Objects.isNull(result.getValue(field))) {
            result.put(field, result.getValue(field));
        }
        return result;
    }

    static JsonArray vertical(JsonArray array, String field, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        JsonArray processed = new JsonArray();
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).map(item -> item.getValue(field)).subscribe(arg_0 -> ((JsonArray)processed).add(arg_0));
        result.clear().addAll(processed);
        return result;
    }

    static <I, O> JsonObject convert(JsonObject entity, String field, Function<I, O> function, boolean immutable) {
        JsonObject result = immutable ? entity.copy() : entity;
        Object value = result.getValue(field);
        if (null != value) {
            Object input = value;
            result.put(field, function.apply(input));
        }
        return result;
    }

    static <I, O> JsonArray convert(JsonArray array, String field, Function<I, O> function, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).subscribe(item -> Self.convert(item, field, function, false));
        return result;
    }

    static JsonObject convert(JsonObject entity, ConcurrentMap<String, String> mapping, boolean immutable) {
        JsonObject result = new JsonObject();
        HashSet<String> keys = new HashSet<String>();
        for (String from : entity.fieldNames()) {
            String to;
            Object value = entity.getValue(from);
            if (null == value) {
                if (!mapping.containsKey(from)) continue;
                to = (String)mapping.get(from);
                result.put(to, value);
                keys.add(from);
                continue;
            }
            if (JsonArray.class == value.getClass()) {
                result.put(from, Self.convert((JsonArray)value, mapping, false));
                continue;
            }
            if (JsonObject.class == value.getClass()) {
                result.put(from, Self.convert((JsonObject)value, mapping, false));
                continue;
            }
            if (!mapping.containsKey(from)) continue;
            to = (String)mapping.get(from);
            result.put(to, value);
            keys.add(from);
        }
        keys.forEach(key -> {
            entity.remove(key);
            result.remove(key);
        });
        return immutable ? result : entity.mergeIn(result, true);
    }

    static JsonArray convert(JsonArray array, ConcurrentMap<String, String> mapping, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        Observable.fromIterable((Iterable)result).map(item -> (JsonObject)item).subscribe(item -> Self.convert(item, mapping, false));
        return result;
    }

    static JsonArray distinct(JsonArray array, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        JsonArray dis = new JsonArray();
        Observable.fromIterable((Iterable)result).distinct().subscribe(arg_0 -> ((JsonArray)dis).add(arg_0));
        return result.clear().addAll(dis);
    }

    static JsonArray sort(JsonArray array, boolean immutable) {
        JsonArray result = immutable ? array.copy() : array;
        JsonArray dis = new JsonArray();
        Observable.fromIterable((Iterable)result).sorted().subscribe(arg_0 -> ((JsonArray)dis).add(arg_0));
        return result.clear().addAll(dis);
    }
}

