/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.Dual;
import io.vertx.up.aiki.Self;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Types;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Uson {
    private static final Annal LOGGER = Annal.get(Uson.class);
    private final transient JsonObject objectReference;

    public static Uson create(String field, Object value) {
        return new Uson(new JsonObject().put(field, value));
    }

    public static Uson create() {
        return new Uson(new JsonObject());
    }

    public static Uson create(JsonObject item) {
        return new Uson(item);
    }

    private Uson(JsonObject json) {
        this.objectReference = Fn.get(new JsonObject(), () -> json, json);
        LOGGER.info("[ ZERO ] ( JsonStream ) Uson/Uarr of {0} initialized data: {1}", String.valueOf(this.hashCode()), json);
    }

    public Uson append(JsonObject object) {
        Dual.append(this.objectReference, object, false);
        return this;
    }

    public Uson append(JsonArray array) {
        Dual.append(this.objectReference, array);
        return this;
    }

    public Uson append(String field, Object value) {
        this.objectReference.put(field, value);
        return this;
    }

    public Uson convert(final String from, final String to) {
        Self.convert(this.objectReference, (ConcurrentMap<String, String>)new ConcurrentHashMap<String, String>(){
            {
                this.put(from, to);
            }
        }, false);
        return this;
    }

    public Uson dft(String field, Object value) {
        Self.defaultValue(this.objectReference, field, value, false);
        return this;
    }

    public Uson dft(JsonObject values) {
        Self.defaultValue(this.objectReference, values, false);
        return this;
    }

    public Uson plus(String from, Integer seed) {
        Object value = this.objectReference.getValue(from);
        if (null != value && Types.isInteger(value)) {
            Integer old = this.objectReference.getInteger(from);
            this.objectReference.put(from, Integer.valueOf(old + seed));
        }
        return this;
    }

    public <I, O> Uson convert(String field, Function<I, O> function) {
        Self.convert(this.objectReference, field, function, false);
        return this;
    }

    public Uson copy(String from, String to) {
        Self.copy(this.objectReference, from, to, false);
        return this;
    }

    public Uson remove(String ... keys) {
        Self.remove(this.objectReference, false, keys);
        return this;
    }

    public Uson denull() {
        Self.deNull(this.objectReference, false);
        return this;
    }

    public JsonObject to() {
        LOGGER.info("[ ZERO ] ( JsonStream ) Uson/Uarr of {0} finished data: {1}", String.valueOf(this.hashCode()), this.objectReference);
        return this.objectReference;
    }

    public Future<JsonObject> toFuture() {
        return Future.succeededFuture((Object)this.to());
    }

    public Object get(String field) {
        return this.objectReference.getValue(field);
    }

    public String toString() {
        return this.objectReference.encode();
    }
}

