/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.func;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

class Pond {
    Pond() {
    }

    static <K, V> V exec(ConcurrentMap<K, V> pool, K key, Supplier<V> poolFn) {
        Object reference = pool.get(key);
        if (null == reference && null != (reference = poolFn.get())) {
            pool.put(key, reference);
        }
        return reference;
    }

    static <K, V, E> ConcurrentMap<K, List<V>> group(Collection<E> object, Function<E, K> keyFn, Function<E, V> valueFn) {
        ConcurrentHashMap ret = new ConcurrentHashMap();
        if (0 < object.size()) {
            for (E item : object) {
                V value;
                K key;
                if (null == item || null == (key = keyFn.apply(item))) continue;
                ArrayList<V> reference = null;
                if (ret.containsKey(key)) {
                    reference = (ArrayList<V>)ret.get(key);
                }
                if (null == reference) {
                    reference = new ArrayList<V>();
                }
                if (null != (value = valueFn.apply(item))) {
                    reference.add(value);
                }
                ret.put(key, reference);
            }
        }
        return ret;
    }

    static <K, V, E> ConcurrentMap<K, V> zipper(Collection<E> object, Function<E, K> keyFn, Function<E, V> valueFn) {
        ConcurrentHashMap<K, V> ret = new ConcurrentHashMap<K, V>();
        if (0 < object.size()) {
            for (E item : object) {
                if (null == item) continue;
                K key = keyFn.apply(item);
                V value = valueFn.apply(item);
                if (null == key || null == value) continue;
                ret.put(key, value);
            }
        }
        return ret;
    }
}

