/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.func;

import io.vertx.up.func.Actuator;
import io.vertx.up.func.JvmSupplier;
import io.vertx.up.func.ZeroActuator;
import io.vertx.up.log.Annal;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.ZeroRunException;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class Zero {
    private static final Annal LOGGER = Annal.get(Zero.class);

    Zero() {
    }

    static <T, F> T nullFlow(F reference, Function<F, T> tranFn, Supplier<T> nextFn) {
        if (null != reference) {
            return tranFn.apply(reference);
        }
        return nextFn.get();
    }

    static <T> void exec(Consumer<T> fnExec, T input) {
        if (null != input) {
            fnExec.accept(input);
        }
    }

    static void exec(Actuator actuator, Object ... input) {
        if (0 < input.length) {
            boolean match = Arrays.stream(input).allMatch(Zero::not);
            if (match) {
                actuator.execute();
            }
        } else {
            actuator.execute();
        }
    }

    static void execZero(ZeroActuator actuator, Object ... input) throws ZeroException {
        if (0 == input.length) {
            actuator.execute();
        } else {
            boolean match = Arrays.stream(input).allMatch(Zero::not);
            if (match) {
                actuator.execute();
            }
        }
    }

    static <T> T getJvm(T defaultValue, JvmSupplier<T> supplier, Object ... input) {
        T ret = null;
        try {
            boolean match = Arrays.stream(input).allMatch(Zero::not);
            if (match && null == (ret = (T)supplier.get())) {
                ret = defaultValue;
            }
        }
        catch (ZeroException ex) {
            LOGGER.zero(ex);
        }
        catch (ZeroRunException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.jvm(ex);
        }
        return ret;
    }

    static <T> T get(T defaultValue, Supplier<T> fnGet, Object ... reference) {
        boolean match = Arrays.stream(reference).allMatch(Zero::not);
        if (match) {
            T ret = fnGet.get();
            return null == ret ? defaultValue : ret;
        }
        return defaultValue;
    }

    private static boolean is(Object item) {
        return null == item;
    }

    private static boolean not(Object item) {
        return !Zero.is(item);
    }
}

