/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BladeDeserializer;
import com.fasterxml.jackson.databind.BladeSerializer;
import com.fasterxml.jackson.databind.ByteArraySerializer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InstantSerializer;
import com.fasterxml.jackson.databind.JsonArrayDeserializer;
import com.fasterxml.jackson.databind.JsonArraySerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.reactivex.Observable;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.Uson;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Ensurer;
import io.vertx.up.tool.mirror.Types;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Supplier;

public final class Jackson {
    private static final Annal LOGGER = Annal.get(Jackson.class);
    public static ObjectMapper MAPPER = new ObjectMapper();

    public static JsonObject visitJObject(JsonObject item, String ... keys) {
        Ensurer.gtLength(Jackson.class, 0, keys);
        return Jackson.searchData(item, JsonObject.class, keys);
    }

    public static JsonArray visitJArray(JsonObject item, String ... keys) {
        Ensurer.gtLength(Jackson.class, 0, keys);
        return Jackson.searchData(item, JsonArray.class, keys);
    }

    public static Integer visitInt(JsonObject item, String ... keys) {
        Ensurer.gtLength(Jackson.class, 0, keys);
        return Jackson.searchData(item, Integer.class, keys);
    }

    public static String visitString(JsonObject item, String ... keys) {
        Ensurer.gtLength(Jackson.class, 0, keys);
        return Jackson.searchData(item, String.class, keys);
    }

    private static <T> T searchData(JsonObject data, Class<T> clazz, String ... pathes) {
        if (null == data || 0 == pathes.length) {
            return null;
        }
        JsonObject current = data;
        String path = pathes[0];
        return (T)Fn.getSemi(current.containsKey(path) && null != current.getValue(path), LOGGER, () -> {
            Object curVal = current.getValue(path);
            Object result = null;
            if (1 == pathes.length) {
                if (clazz == curVal.getClass()) {
                    result = curVal;
                }
            } else if (Types.isJObject(curVal)) {
                JsonObject continueNode = current.getJsonObject(path);
                String[] continueKeys = Arrays.copyOfRange(pathes, 1, pathes.length);
                result = Jackson.searchData(continueNode, clazz, continueKeys);
            }
            return result;
        }, Fn::nil);
    }

    public static JsonArray mergeZip(JsonArray source, JsonArray target, String sourceKey, String targetKey) {
        JsonArray result = new JsonArray();
        Fn.safeJvm(() -> Observable.fromIterable((Iterable)source).filter(Objects::nonNull).map(item -> (JsonObject)item).map(item -> item.mergeIn(Jackson.findByKey(target, targetKey, item.getValue(sourceKey)))).subscribe(arg_0 -> ((JsonArray)result).add(arg_0)), LOGGER);
        return result;
    }

    private static JsonObject findByKey(JsonArray source, String key, Object value) {
        return Fn.getJvm(() -> (JsonObject)Observable.fromIterable((Iterable)source).filter(Objects::nonNull).map(item -> (JsonObject)item).filter(item -> null != item.getValue(key)).filter(item -> value == item.getValue(key) || item.getValue(key).equals(value)).first((Object)new JsonObject()).blockingGet(), source, key);
    }

    public static JsonObject validJObject(Supplier<JsonObject> supplier) {
        JsonObject result;
        try {
            result = supplier.get();
        }
        catch (DecodeException ex) {
            result = new JsonObject();
        }
        return result;
    }

    public static JsonArray validJArray(Supplier<JsonArray> supplier) {
        JsonArray result;
        try {
            result = supplier.get();
        }
        catch (DecodeException ex) {
            result = new JsonArray();
        }
        return result;
    }

    public static JsonArray toJArray(Object value) {
        JsonArray result = new JsonArray();
        Fn.safeNull(() -> {
            if (Types.isJArray(value)) {
                result.addAll((JsonArray)value);
            } else {
                result.add(value.toString());
            }
        }, value);
        return result;
    }

    public static <T, R extends Iterable> R serializeJson(T t) {
        String content = Jackson.serialize(t);
        return (R)Fn.getJvm(null, () -> Fn.getSemi(content.trim().startsWith("{"), LOGGER, () -> new JsonObject(content), () -> new JsonArray(content)), new Object[]{content});
    }

    public static <T> String serialize(T t) {
        return Fn.get(null, () -> Fn.getJvm(() -> MAPPER.writeValueAsString(t), t), new Object[]{t});
    }

    public static <T> T deserialize(JsonObject value, Class<T> type) {
        return (T)Fn.get(null, () -> Jackson.deserialize(value.encode(), type), new Object[]{value});
    }

    public static <T> T deserialize(JsonArray value, Class<T> type) {
        return (T)Fn.get(null, () -> Jackson.deserialize(value.encode(), type), new Object[]{value});
    }

    public static <T> List<T> deserialize(JsonArray value, TypeReference<List<T>> type) {
        return Fn.get(new ArrayList(), () -> (List)Jackson.deserialize(value.encode(), type), value);
    }

    public static <T> T deserialize(String value, Class<T> type) {
        return (T)Fn.get(null, () -> Fn.getJvm(() -> MAPPER.readValue(value, type), new Object[0]), new Object[]{value});
    }

    public static <T> T deserialize(String value, TypeReference<T> type) {
        return (T)Fn.get(null, () -> Fn.getJvm(() -> MAPPER.readValue(value, type), new Object[0]), new Object[]{value});
    }

    public static <T> List<T> convert(List<JsonObject> result, Class<T> clazz) {
        ArrayList entities = new ArrayList();
        result.forEach(item -> entities.add(Jackson.deserialize(item.encode(), clazz)));
        return entities;
    }

    private Jackson() {
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        MAPPER.setDateFormat((DateFormat)dateFormat);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (JsonSerializer)new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, (JsonSerializer)new JsonArraySerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        module.addSerializer(Uson.class, (JsonSerializer)new BladeSerializer());
        module.addDeserializer(Uson.class, (JsonDeserializer)new BladeDeserializer());
        module.addDeserializer(JsonObject.class, (JsonDeserializer)new JsonObjectDeserializer());
        module.addDeserializer(JsonArray.class, (JsonDeserializer)new JsonArrayDeserializer());
        MAPPER.registerModule((Module)module);
        MAPPER.findAndRegisterModules();
    }
}

