/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import io.vertx.up.func.Fn;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Numeric {
    private static boolean isMatch(String regex, String original) {
        return Fn.get(() -> {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(original);
            return matcher.matches();
        }, regex, original);
    }

    public static boolean isPositive(String original) {
        return Numeric.isMatch("^\\+{0,1}[0-9]\\d*", original);
    }

    public static boolean isNegative(String original) {
        return Numeric.isMatch("^-[0-9]\\d*", original);
    }

    public static boolean isInteger(String original) {
        return Numeric.isMatch("[+-]{0,1}0", original) || Numeric.isPositive(original) || Numeric.isNegative(original);
    }

    public static boolean isDecimal(String original) {
        return Numeric.isMatch("[-+]{0,1}\\d+\\.\\d*|[-+]{0,1}\\d*\\.\\d+", original);
    }

    public static boolean isReal(String original) {
        return Numeric.isInteger(original) || Numeric.isDecimal(original);
    }

    public static class Decimal {
        public static boolean isPositive(String original) {
            return Numeric.isMatch("\\+{0,1}[0]\\.[1-9]*|\\+{0,1}[1-9]\\d*\\.\\d*", original);
        }

        public static boolean isNegative(String original) {
            return Numeric.isMatch("^-[0]\\.[1-9]*|^-[1-9]\\d*\\.\\d*", original);
        }
    }
}

