/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.tool.Storage;
import io.vertx.up.tool.StoreConfig;
import io.vertx.up.tool.StoreFormat;
import io.vertx.up.tool.StoreType;
import io.vertx.up.tool.io.IO;

public final class Store {
    public static ConfigStoreOptions getJson(String filename) {
        return Fn.getJvm(() -> {
            JsonObject data = IO.getJObject(filename);
            return Fn.getJvm(() -> Fn.pool(Storage.STORE, filename, () -> new ConfigStoreOptions().setType(StoreType.JSON.key()).setConfig(data)), data);
        }, filename);
    }

    public static ConfigStoreOptions getYaml(String filename) {
        return Store.getFile(filename, StoreFormat.YAML);
    }

    public static ConfigStoreOptions getProp(String filename) {
        return Store.getFile(filename, StoreFormat.PROP);
    }

    private static ConfigStoreOptions getFile(String filename, StoreFormat format) {
        return Fn.getJvm(() -> {
            JsonObject config = new JsonObject().put(StoreConfig.PATH.key(), IO.getPath(filename));
            return Fn.pool(Storage.STORE, filename, () -> new ConfigStoreOptions().setType(StoreType.FILE.key()).setFormat(format.key()).setConfig(config));
        }, new Object[]{filename, format});
    }

    private Store() {
    }
}

