/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import java.util.HashSet;
import java.util.Set;

public class StringUtil {
    public static String from(Object value) {
        return null == value ? "" : value.toString();
    }

    public static String from(JsonObject value) {
        return null == value ? "" : value.toString();
    }

    public static Set<String> split(String input, String separator) {
        return Fn.get(new HashSet(), () -> {
            String[] array = input.split(separator);
            HashSet result = new HashSet();
            for (String item : array) {
                Fn.safeNull(() -> result.add(item.trim().intern()), item);
            }
            return result;
        }, input, separator);
    }

    public static String join(Set<String> input) {
        return StringUtil.join(input, null);
    }

    public static String join(Set<String> input, String separator) {
        String connector = null == separator ? "," : separator;
        return Fn.getJvm(() -> {
            StringBuilder builder = new StringBuilder();
            int size = input.size();
            int start = 0;
            for (String item : input) {
                builder.append(item);
                if (++start >= size) continue;
                builder.append(connector);
            }
            return builder.toString();
        }, input);
    }

    public static String join(Object[] input) {
        HashSet<String> data = new HashSet<String>();
        for (Object item : input) {
            if (null == item) continue;
            data.add(item.toString());
        }
        return StringUtil.join(data);
    }

    public static boolean isNil(String input) {
        return null == input || 0 == input.trim().length();
    }

    public static boolean notNil(String input) {
        return !StringUtil.isNil(input);
    }
}

