/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.up.func.Fn;
import io.vertx.up.tool.io.Stream;
import io.vertx.zero.eon.em.YamlType;
import io.vertx.zero.exception.heart.EmptyStreamException;
import io.vertx.zero.exception.heart.JsonFormatException;
import io.vertx.zero.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

public final class IO {
    private static final ObjectMapper YAML = new YAMLMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(IO.class);

    public static JsonArray getJArray(String filename) {
        return Fn.transRun(() -> new JsonArray(IO.getString(filename)), JsonFormatException.class, filename);
    }

    public static JsonObject getJObject(String filename) {
        String content = IO.getString(filename);
        return Fn.transRun(() -> new JsonObject(content), JsonFormatException.class, filename);
    }

    public static String getString(InputStream in) {
        StringBuilder buffer = new StringBuilder(16);
        return Fn.getJvm(() -> {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while (null != (line = reader.readLine())) {
                buffer.append(line);
            }
            reader.close();
            return buffer.toString();
        }, in);
    }

    public static String getString(String filename) {
        return Fn.getJvm(() -> IO.getString(Stream.read(filename)), filename);
    }

    public static <T> T getYaml(String filename) {
        YamlType type = IO.getYamlType(filename);
        return (T)Fn.getSemi(YamlType.ARRAY == type, null, () -> Fn.getJvm(() -> new JsonArray(IO.getYamlNode(filename).toString()), filename), () -> Fn.getJvm(() -> new JsonObject(IO.getYamlNode(filename).toString()), filename));
    }

    private static JsonNode getYamlNode(String filename) {
        InputStream in = Stream.read(filename);
        JsonNode node = Fn.safeJvm(() -> {
            if (null == in) {
                throw new EmptyStreamException(filename);
            }
            return YAML.readTree(in);
        }, null);
        if (null == node) {
            throw new EmptyStreamException(filename);
        }
        return node;
    }

    public static YamlType getYamlType(String filename) {
        String content = IO.getString(filename);
        return Fn.get(YamlType.OBJECT, () -> {
            if (content.trim().startsWith("-")) {
                return YamlType.ARRAY;
            }
            return YamlType.OBJECT;
        }, content);
    }

    public static Properties getProp(String filename) {
        return Fn.getJvm(() -> {
            Properties prop = new Properties();
            InputStream in = Stream.read(filename);
            prop.load(in);
            in.close();
            return prop;
        }, filename);
    }

    public static URL getURL(String filename) {
        return Fn.getJvm(() -> {
            URL url = Thread.currentThread().getContextClassLoader().getResource(filename);
            return Fn.getSemi(null == url, null, () -> IO.class.getResource(filename), () -> url);
        }, filename);
    }

    public static File getFile(String filename) {
        return Fn.getJvm(() -> {
            File file = new File(filename);
            return Fn.getSemi(file.exists(), null, () -> file, () -> {
                URL url = IO.getURL(filename);
                if (null == url) {
                    throw new EmptyStreamException(filename);
                }
                return new File(url.getFile());
            });
        }, filename);
    }

    public static String getPath(String filename) {
        return Fn.getJvm(() -> {
            File file = IO.getFile(filename);
            return Fn.getJvm(() -> {
                Log.info(LOGGER, "[ZERO] Absolute path is hitted: {0}.", file.getAbsolutePath());
                return file.getAbsolutePath();
            }, file);
        }, filename);
    }

    private IO() {
    }
}

