/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.io;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.up.func.Fn;
import io.vertx.zero.exception.heart.EmptyStreamException;
import io.vertx.zero.log.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class Stream {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stream.class);

    public static <T> byte[] to(T message) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        return Fn.getJvm(new byte[0], () -> {
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(message);
            out.close();
            return bytes.toByteArray();
        }, bytes);
    }

    public static <T> T from(int pos, Buffer buffer) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.getBytes());
        return (T)Fn.getJvm(null, () -> {
            ObjectInputStream in = new ObjectInputStream(stream);
            return in.readObject();
        }, new Object[]{stream});
    }

    public static InputStream read(String filename) {
        return Stream.read(filename, null);
    }

    public static InputStream read(String filename, Class<?> clazz) {
        File file = new File(filename);
        Log.debug(LOGGER, "[ZERO] Current path is scanned by the system, file existing ? {0}.", file.exists());
        InputStream in = Fn.getSemi(file.exists(), null, () -> Stream.in(file), () -> null == clazz ? Stream.in(filename) : Stream.in(filename, clazz));
        Log.debug(LOGGER, "[ZERO] The system class Stream try to data from {0}, got stream: {1}.", filename, in);
        if (null == in) {
            throw new EmptyStreamException(filename);
        }
        return in;
    }

    public static InputStream in(File file) {
        return Fn.getJvm(() -> file.exists() && file.isFile() ? new FileInputStream(file) : null, file);
    }

    public static InputStream in(String filename, Class<?> clazz) {
        return Fn.getJvm(() -> clazz.getResourceAsStream(filename), clazz, filename);
    }

    public static InputStream in(String filename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Fn.getJvm(() -> loader.getResourceAsStream(filename), filename);
    }

    private Stream() {
    }
}

