/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.mirror;

import io.vertx.up.func.Fn;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import zava.io.ClassFileFilter;

public class PackScanner {
    static Set<Class<?>> getClasses(Predicate<Class<?>> filter, String zeroScan) {
        LinkedHashSet classes = new LinkedHashSet();
        return Fn.get(() -> {
            boolean recursive = true;
            String packageDir = ".".equals(zeroScan) ? zeroScan.replace(".", "") : zeroScan.replace(".", "/");
            Fn.safeJvm(() -> {
                Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDir);
                while (dirs.hasMoreElements()) {
                    URL url = dirs.nextElement();
                    if (null == url) continue;
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        String path = URLDecoder.decode(url.getFile(), "UTF-8");
                        PackScanner.findAndAdd(packageDir, path, true, classes);
                        continue;
                    }
                    if (!"jar".equals(protocol)) continue;
                    classes.addAll(PackScanner.getClasses(packageDir, zeroScan, url, true));
                }
            }, null);
            return null == filter ? classes : classes.stream().filter(filter).collect(Collectors.toSet());
        }, zeroScan);
    }

    private static Set<Class<?>> getClasses(String packageDir, String packName, URL url, boolean recursive) {
        LinkedHashSet classes = new LinkedHashSet();
        Fn.getJvm(() -> {
            String packageName = packName.startsWith(".") ? packName.substring(1, packName.length()) : packName;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDir)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
                }
                catch (Throwable throwable) {}
            }
            return null;
        }, packageDir, packName, url);
        return classes;
    }

    private static void findAndAdd(String packName, String packPath, boolean recursive, Set<Class<?>> classesRef) {
        File file = new File(packPath);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        Object[] dirfiles = file.listFiles(new ClassFileFilter());
        String packageName = packName.startsWith(".") ? packName.substring(1, packName.length()) : packName;
        String processedName = packageName.replace("/", ".");
        Fn.safeNull(() -> PackScanner.lambda$findAndAdd$3((File[])dirfiles, processedName, recursive, classesRef), dirfiles);
    }

    private static /* synthetic */ void lambda$findAndAdd$3(File[] dirfiles, String processedName, boolean recursive, Set classesRef) {
        for (File classFile : dirfiles) {
            if (classFile.isDirectory()) {
                PackScanner.findAndAdd(processedName + "." + classFile.getName(), classFile.getAbsolutePath(), recursive, classesRef);
                continue;
            }
            String className = classFile.getName().substring(0, classFile.getName().length() - 6);
            try {
                classesRef.add(Thread.currentThread().getContextClassLoader().loadClass(processedName + "." + className));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

