/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.mirror;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Numeric;
import io.vertx.up.tool.Period;
import io.vertx.up.tool.mirror.Instance;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Types {
    private static final Annal LOGGER = Annal.get(Types.class);
    private static final ObjectMapper YAML = new YAMLMapper();
    public static ConcurrentMap<Class<?>, Class<?>> UNBOXES = new ConcurrentHashMap<Class<?>, Class<?>>(){
        {
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Character.class, Character.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Byte.class, Byte.TYPE);
        }
    };

    public static <T extends Enum<T>> T fromStr(Class<T> clazz, String input) {
        return (T)Fn.get(null, () -> Enum.valueOf(clazz, input), new Object[]{clazz, input});
    }

    public static boolean isJArray(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> Types.isJArray(value.getClass()));
    }

    public static boolean isJArray(Class<?> clazz) {
        return JsonArray.class == clazz;
    }

    public static boolean isVoid(Class<?> clazz) {
        return null == clazz || Void.class == clazz || Void.TYPE == clazz;
    }

    public static boolean isClass(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> null != Instance.clazz(value.toString()));
    }

    public static boolean isJObject(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> Types.isJObject(value.getClass()));
    }

    public static boolean isJObject(Class<?> clazz) {
        return JsonObject.class == clazz || LinkedHashMap.class == clazz;
    }

    public static boolean isInteger(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> Numeric.isInteger(value.toString()));
    }

    public static boolean isInteger(Class<?> clazz) {
        return Integer.TYPE == clazz || Integer.class == clazz || Long.TYPE == clazz || Long.class == clazz || Short.TYPE == clazz || Short.class == clazz;
    }

    public static boolean isDecimal(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> Numeric.isDecimal(value.toString()));
    }

    public static boolean isDeciaml(Class<?> clazz) {
        return Double.TYPE == clazz || Double.class == clazz || Float.TYPE == clazz || Float.class == clazz || BigDecimal.class == clazz;
    }

    public static boolean isBoolean(Class<?> clazz) {
        return Boolean.TYPE == clazz || Boolean.class == clazz;
    }

    public static boolean isBoolean(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> {
            boolean logical = false;
            String literal = value.toString();
            if ("true".equalsIgnoreCase(literal) || Integer.valueOf(1).toString().equalsIgnoreCase(literal) || "false".equalsIgnoreCase(literal) || Integer.valueOf(0).toString().equalsIgnoreCase(literal)) {
                logical = true;
            }
            return logical;
        });
    }

    public static boolean isDate(Object value) {
        return Fn.getSemi(null == value, LOGGER, () -> false, () -> Period.isValid(value.toString()));
    }

    public static boolean isArray(Object value) {
        if (null == value) {
            return false;
        }
        return value instanceof Collection || value.getClass().isArray();
    }

    public static String toString(Object reference) {
        return Fn.get("null", () -> {
            String literal = Types.isJObject(reference) ? ((JsonObject)reference).encode() : (Types.isJArray(reference) ? ((JsonArray)reference).encode() : reference.toString());
            return literal;
        }, reference);
    }

    public static <T> JsonArray toJArray(Set<T> set) {
        JsonArray array = new JsonArray();
        Observable.fromIterable(set).subscribe(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    public static Collection toCollection(Object value) {
        return Fn.get(() -> {
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (Types.isJArray(value)) {
                return ((JsonArray)value).getList();
            }
            if (Types.isArray(value)) {
                Object[] values = (Object[])value;
                return Arrays.asList(values);
            }
            return null;
        }, value);
    }

    public static boolean isPrimary(Class<?> source) {
        return UNBOXES.values().contains(source);
    }

    public static Class<?> toPrimary(Class<?> source) {
        return UNBOXES.getOrDefault(source, source);
    }
}

